/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.context.orm.OrmDerivedIdentity2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmMapsIdDerivedIdentityStrategy2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmSingleRelationshipMapping2_0;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmMapsIdDerivedIdentityStrategy2_0
extends AbstractOrmXmlContextNode
implements OrmMapsIdDerivedIdentityStrategy2_0 {
    protected XmlMapsId_2_0 resource;
    protected String value;

    public GenericOrmMapsIdDerivedIdentityStrategy2_0(OrmDerivedIdentity2_0 parent, XmlMapsId_2_0 resource) {
        super(parent);
        this.resource = resource;
        this.value = this.resource.getMapsId();
    }

    @Override
    public OrmDerivedIdentity2_0 getDerivedIdentity() {
        return (OrmDerivedIdentity2_0)this.getParent();
    }

    @Override
    public OrmSingleRelationshipMapping2_0 getMapping() {
        return this.getDerivedIdentity().getMapping();
    }

    @Override
    public String getSpecifiedValue() {
        return this.value;
    }

    @Override
    public void setSpecifiedValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.resource.setMapsId(this.value);
        this.firePropertyChanged("specified-value", oldValue, newValue);
    }

    protected void setSpecifiedValue_(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.firePropertyChanged("specified-value", oldValue, newValue);
    }

    @Override
    public boolean usesDefaultValue() {
        return false;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Iterable<String> getSortedValueChoices() {
        return CollectionTools.sort((Iterable)new TransformationIterable<AttributeMapping, String>(this.getAllAttributeMappingChoices()){

            protected String transform(AttributeMapping o) {
                return o.getName();
            }
        });
    }

    public Iterable<AttributeMapping> getAllAttributeMappingChoices() {
        return new CompositeIterable(this.getAttributeMappingChoiceIterables((Iterable<AttributeMapping>)CollectionTools.collection(this.getMapping().getPersistentAttribute().getOwningTypeMapping().allAttributeMappings())));
    }

    protected Iterable<Iterable<AttributeMapping>> getAttributeMappingChoiceIterables(Iterable<AttributeMapping> availableMappings) {
        return new TransformationIterable<AttributeMapping, Iterable<AttributeMapping>>(availableMappings){

            protected Iterable<AttributeMapping> transform(AttributeMapping o) {
                if (StringTools.stringsAreEqual((String)o.getKey(), (String)"embeddedId")) {
                    return GenericOrmMapsIdDerivedIdentityStrategy2_0.this.getEmbeddedIdMappingChoiceIterable((EmbeddedIdMapping)o);
                }
                return new SingleElementIterable((Object)o);
            }
        };
    }

    protected Iterable<AttributeMapping> getEmbeddedIdMappingChoiceIterable(EmbeddedIdMapping mapping) {
        Embeddable embeddable = mapping.getTargetEmbeddable();
        if (embeddable == null) {
            return new SingleElementIterable((Object)mapping);
        }
        return new CompositeIterable((Object)mapping, (Iterable)CollectionTools.collection(embeddable.allAttributeMappings()));
    }

    @Override
    public AttributeMapping getResolvedAttributeMappingValue() {
        if (this.getValue() != null) {
            for (AttributeMapping each : this.getAllAttributeMappingChoices()) {
                if (!Tools.valuesAreEqual((Object)each.getName(), (Object)this.getValue())) continue;
                return each;
            }
        }
        return null;
    }

    @Override
    public boolean isSpecified() {
        return this.resource.getMapsId() != null;
    }

    @Override
    public void addStrategy() {
        this.resource.setMapsId("");
    }

    @Override
    public void removeStrategy() {
        this.resource.setMapsId(null);
    }

    @Override
    public void update() {
        this.setSpecifiedValue_(this.resource.getMapsId());
    }

    @Override
    public void initializeFrom(OrmMapsIdDerivedIdentityStrategy2_0 oldStrategy) {
        this.setSpecifiedValue(oldStrategy.getSpecifiedValue());
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.resource.getMapsIdTextRange();
        return textRange == null ? this.getDerivedIdentity().getValidationTextRange() : textRange;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMapsId(messages, reporter);
    }

    protected void validateMapsId(List<IMessage> messages, IReporter reporter) {
        if (!this.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy()) {
            return;
        }
        AttributeMapping attributeMappingValue = this.getResolvedAttributeMappingValue();
        if (attributeMappingValue == null) {
            messages.add(this.buildMessage("MAPS_ID_VALUE_NOT_RESOLVED", new String[]{this.getValue()}));
        }
        if (attributeMappingValue != null && !CollectionTools.contains(this.getValidAttributeMappingChoices(), (Object)attributeMappingValue)) {
            messages.add(this.buildMessage("MAPS_ID_VALUE_INVALID", new String[]{this.getValue()}));
        }
    }

    protected Iterable<AttributeMapping> getValidAttributeMappingChoices() {
        return new CompositeIterable(this.getAttributeMappingChoiceIterables((Iterable<AttributeMapping>)new FilteringIterable<AttributeMapping>((Iterable)CollectionTools.collection(this.getMapping().getPersistentAttribute().getOwningTypeMapping().allAttributeMappings())){

            protected boolean accept(AttributeMapping o) {
                return StringTools.stringsAreEqual((String)o.getKey(), (String)"id") || StringTools.stringsAreEqual((String)o.getKey(), (String)"embeddedId");
            }
        }));
    }

    protected IMessage buildMessage(String msgID, String[] params) {
        OrmPersistentAttribute attribute = this.getDerivedIdentity().getMapping().getPersistentAttribute();
        String attributeDescString = attribute.isVirtual() ? NLS.bind((String)JpaValidationDescriptionMessages.VIRTUAL_ATTRIBUTE_DESC, (Object)attribute.getName()) : NLS.bind((String)JpaValidationDescriptionMessages.ATTRIBUTE_DESC, (Object)attribute.getName());
        return DefaultJpaValidationMessages.buildMessage(1, msgID, (String[])ArrayTools.add((Object[])params, (int)0, (Object)attributeDescString), this, this.getValidationTextRange());
    }
}

