/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;

abstract class BinaryGeneratorAnnotation
extends BinaryAnnotation
implements GeneratorAnnotation {
    String name = this.buildName();
    Integer initialValue = this.buildInitialValue();
    Integer allocationSize = this.buildAllocationSize();

    BinaryGeneratorAnnotation(JavaResourceNode parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public void update() {
        super.update();
        this.setName_(this.buildName());
        this.setInitialValue_(this.buildInitialValue());
        this.setAllocationSize_(this.buildAllocationSize());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    private void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName() {
        return (String)this.getJdtMemberValue(this.getNameElementName());
    }

    abstract String getNameElementName();

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Integer initialValue) {
        throw new UnsupportedOperationException();
    }

    private void setInitialValue_(Integer initialValue) {
        Integer old = this.initialValue;
        this.initialValue = initialValue;
        this.firePropertyChanged("initialValue", old, initialValue);
    }

    private Integer buildInitialValue() {
        return (Integer)this.getJdtMemberValue(this.getInitialValueElementName());
    }

    abstract String getInitialValueElementName();

    public TextRange getInitialValueTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(Integer allocationSize) {
        throw new UnsupportedOperationException();
    }

    private void setAllocationSize_(Integer allocationSize) {
        Integer old = this.allocationSize;
        this.allocationSize = allocationSize;
        this.firePropertyChanged("name", old, allocationSize);
    }

    private Integer buildAllocationSize() {
        return (Integer)this.getJdtMemberValue(this.getAllocationSizeElementName());
    }

    abstract String getAllocationSizeElementName();

    public TextRange getAllocationSizeTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }
}

