/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.VersionAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaVersionMapping
extends AbstractJavaAttributeMapping<VersionAnnotation>
implements JavaVersionMapping {
    protected final JavaColumn column = this.getJpaFactory().buildJavaColumn(this, this);
    protected JavaConverter converter = this.nullConverter = this.getJpaFactory().buildJavaNullConverter(this);
    protected final JavaConverter nullConverter;

    protected AbstractJavaVersionMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.column.initialize(this.getResourceColumn());
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    public ColumnAnnotation getResourceColumn() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Version";
    }

    @Override
    protected void addSupportingAnnotationNamesTo(Vector<String> names) {
        super.addSupportingAnnotationNamesTo(names);
        names.add("javax.persistence.Column");
        names.add("javax.persistence.Temporal");
    }

    @Override
    public String getDefaultColumnName() {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getTypeMapping().associatedTableNamesIncludingInherited();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public JavaConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getConverterType(), converterType)) {
            return;
        }
        JavaConverter oldConverter = this.converter;
        JavaConverter newConverter = this.buildConverter(converterType);
        this.converter = this.nullConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.converter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    @Override
    protected void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getConverterType())) {
            this.getConverter().update(this.getResourcePersistentAttribute());
        } else {
            JavaConverter javaConverter = this.buildConverter(this.getResourceConverterType());
            this.setConverter(javaConverter);
        }
    }

    protected JavaConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullConverter;
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.getResourcePersistentAttribute());
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (this.getResourcePersistentAttribute().getAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        return "noConverter";
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getConverter().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.getColumn().validate(messages, reporter, astRoot);
        this.getConverter().validate(messages, reporter, astRoot);
    }

    @Override
    public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }

    @Override
    public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
    }
}

