/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityMappings
extends AbstractOrmXmlContextNode
implements EntityMappings {
    protected final XmlEntityMappings xmlEntityMappings;
    protected String description;
    protected String package_;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final PersistenceUnitMetadata persistenceUnitMetadata;
    protected final List<OrmPersistentType> persistentTypes;
    protected final List<OrmSequenceGenerator> sequenceGenerators;
    protected final List<OrmTableGenerator> tableGenerators;
    protected final OrmQueryContainer queryContainer;
    protected static final Comparator<OrmPersistentType> MAPPING_COMPARATOR = new Comparator<OrmPersistentType>(){

        @Override
        public int compare(OrmPersistentType o1, OrmPersistentType o2) {
            int o2Sequence;
            int o1Sequence = o1.getMapping().getXmlSequence();
            if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                return -1;
            }
            if (o1Sequence == o2Sequence) {
                return 0;
            }
            return 1;
        }
    };

    protected AbstractEntityMappings(OrmXml parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.xmlEntityMappings = xmlEntityMappings;
        this.persistentTypes = new ArrayList<OrmPersistentType>();
        this.sequenceGenerators = new ArrayList<OrmSequenceGenerator>();
        this.tableGenerators = new ArrayList<OrmTableGenerator>();
        this.queryContainer = this.getXmlContextNodeFactory().buildOrmQueryContainer(this, xmlEntityMappings);
        this.persistenceUnitMetadata = this.buildPersistenceUnitMetadata();
        this.description = this.xmlEntityMappings.getDescription();
        this.package_ = this.xmlEntityMappings.getPackage();
        this.defaultAccess = this.getPersistenceUnit().getDefaultAccess();
        this.specifiedAccess = this.getResourceAccess();
        this.defaultCatalog = this.getPersistenceUnit().getDefaultCatalog();
        this.specifiedCatalog = this.xmlEntityMappings.getCatalog();
        this.defaultSchema = this.getPersistenceUnit().getDefaultSchema();
        this.specifiedSchema = this.xmlEntityMappings.getSchema();
        this.initializePersistentTypes();
        this.initializeTableGenerators();
        this.initializeSequenceGenerators();
    }

    protected PersistenceUnitMetadata buildPersistenceUnitMetadata() {
        return this.getXmlContextNodeFactory().buildPersistenceUnitMetadata(this);
    }

    protected OrmPersistentType buildPersistentType(XmlTypeMapping resourceMapping) {
        return this.getXmlContextNodeFactory().buildOrmPersistentType(this, resourceMapping);
    }

    @Override
    public OrmXml getParent() {
        return (OrmXml)super.getParent();
    }

    protected OrmXml getOrmXml() {
        return this.getParent();
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return this;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.entityMappings";
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.isXmlMappingMetadataComplete() ? this.getSpecifiedAccess() : null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getAccess();
    }

    @Override
    public String getDefaultPersistentTypePackage() {
        return this.getPackage();
    }

    protected boolean isXmlMappingMetadataComplete() {
        return this.persistenceUnitMetadata.isXmlMappingMetadataComplete();
    }

    @Override
    public boolean isDefaultPersistentTypeMetadataComplete() {
        return this.isXmlMappingMetadataComplete();
    }

    @Override
    public XmlEntityMappings getXmlEntityMappings() {
        return this.xmlEntityMappings;
    }

    @Override
    public void changeMapping(OrmPersistentType ormPersistentType, OrmTypeMapping oldMapping, OrmTypeMapping newMapping) {
        AccessType savedAccess = ormPersistentType.getSpecifiedAccess();
        ormPersistentType.dispose();
        int sourceIndex = this.persistentTypes.indexOf(ormPersistentType);
        this.persistentTypes.remove(sourceIndex);
        oldMapping.removeFromResourceModel(this.xmlEntityMappings);
        int targetIndex = this.insertionIndex(ormPersistentType);
        this.persistentTypes.add(targetIndex, ormPersistentType);
        newMapping.addToResourceModel(this.xmlEntityMappings);
        newMapping.initializeFrom(oldMapping);
        ormPersistentType.setSpecifiedAccess(savedAccess);
        this.fireItemMoved("persistentTypes", targetIndex, sourceIndex);
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            if (!ormPersistentType.isFor(fullyQualifiedTypeName)) continue;
            return ormPersistentType;
        }
        return null;
    }

    @Override
    public boolean containsPersistentType(String fullyQualifiedTypeName) {
        return this.getPersistentType(fullyQualifiedTypeName) != null;
    }

    @Override
    public PersistentType resolvePersistentType(String className) {
        if (className == null) {
            return null;
        }
        className = className.replace('$', '.');
        PersistentType mapKeyPersistentType = this.getPersistenceUnit().getPersistentType(className);
        if (mapKeyPersistentType != null) {
            return mapKeyPersistentType;
        }
        if (this.getPackage() == null) {
            return null;
        }
        return this.getPersistenceUnit().getPersistentType(String.valueOf(this.getPackage()) + '.' + className);
    }

    @Override
    public JavaResourcePersistentType resolveJavaResourcePersistentType(String className) {
        if (className == null) {
            return null;
        }
        className = className.replace('$', '.');
        JavaResourcePersistentType jrpt = this.getJpaProject().getJavaResourcePersistentType(className);
        if (jrpt != null) {
            return jrpt;
        }
        if (this.getPackage() == null) {
            return null;
        }
        return this.getJpaProject().getJavaResourcePersistentType(String.valueOf(this.getPackage()) + '.' + className);
    }

    @Override
    public PersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String newPackage) {
        String oldPackage = this.package_;
        this.package_ = newPackage;
        this.xmlEntityMappings.setPackage(newPackage);
        this.firePropertyChanged("package", oldPackage, newPackage);
    }

    @Override
    public String getVersion() {
        return this.xmlEntityMappings.getVersion();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        this.xmlEntityMappings.setDescription(newDescription);
        this.firePropertyChanged("description", oldDescription, newDescription);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.xmlEntityMappings.setAccess(AccessType.toOrmResourceModel(access));
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)access);
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.xmlEntityMappings.setSchema(schema);
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.xmlEntityMappings.setCatalog(catalog);
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.getDbCatalog(catalog);
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    public ListIterator<OrmPersistentType> persistentTypes() {
        return new CloneListIterator(this.persistentTypes);
    }

    @Override
    public ListIterable<OrmPersistentType> getPersistentTypes() {
        return new LiveCloneListIterable(this.persistentTypes);
    }

    @Override
    public int getPersistentTypesSize() {
        return this.persistentTypes.size();
    }

    @Override
    public OrmPersistentType addPersistentType(String mappingKey, String className) {
        OrmTypeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getOrmTypeMappingDefinition(mappingKey);
        XmlTypeMapping typeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentType persistentType = this.buildPersistentType(typeMapping);
        int index = this.insertionIndex(persistentType);
        this.persistentTypes.add(index, persistentType);
        if (className.startsWith(String.valueOf(this.getPackage()) + '.')) {
            className = className.substring(this.getPackage().length() + 1);
        }
        persistentType.getMapping().addToResourceModel(this.xmlEntityMappings);
        typeMapping.setClassName(className);
        this.fireItemAdded("persistentTypes", index, persistentType);
        return persistentType;
    }

    protected int insertionIndex(OrmPersistentType ormPersistentType) {
        return CollectionTools.insertionIndexOf(this.persistentTypes, (Object)ormPersistentType, MAPPING_COMPARATOR);
    }

    @Override
    public void removePersistentType(int index) {
        OrmPersistentType persistentType = this.persistentTypes.get(index);
        persistentType.dispose();
        this.persistentTypes.remove(index);
        persistentType.getMapping().removeFromResourceModel(this.xmlEntityMappings);
        this.fireItemRemoved("persistentTypes", index, persistentType);
    }

    @Override
    public void removePersistentType(OrmPersistentType persistentType) {
        this.removePersistentType(this.persistentTypes.indexOf(persistentType));
    }

    protected void removePersistentType_(OrmPersistentType persistentType) {
        persistentType.dispose();
        this.removeItemFromList(persistentType, this.persistentTypes, "persistentTypes");
    }

    protected void movePersistentType_(int index, OrmPersistentType persistentType) {
        this.moveItemInList(index, this.persistentTypes.indexOf(persistentType), this.persistentTypes, "persistentTypes");
    }

    @Override
    public ListIterable<OrmSequenceGenerator> getSequenceGenerators() {
        return new LiveCloneListIterable(this.sequenceGenerators);
    }

    @Override
    public int getSequenceGeneratorsSize() {
        return this.sequenceGenerators.size();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator(int index) {
        XmlSequenceGenerator resourceSequenceGenerator = this.buildResourceSequenceGenerator();
        OrmSequenceGenerator contextSequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        this.sequenceGenerators.add(index, contextSequenceGenerator);
        this.xmlEntityMappings.getSequenceGenerators().add(index, (Object)resourceSequenceGenerator);
        this.fireItemAdded("sequenceGenerators", index, contextSequenceGenerator);
        return contextSequenceGenerator;
    }

    protected void addSequenceGenerator(int index, OrmSequenceGenerator sequenceGenerator) {
        this.addItemToList(index, sequenceGenerator, this.sequenceGenerators, "sequenceGenerators");
    }

    protected void addSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.addSequenceGenerator(this.sequenceGenerators.size(), sequenceGenerator);
    }

    @Override
    public void removeSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator(this.sequenceGenerators.indexOf(sequenceGenerator));
    }

    @Override
    public void removeSequenceGenerator(int index) {
        OrmSequenceGenerator removedSequenceGenerator = this.sequenceGenerators.remove(index);
        this.fireItemRemoved("sequenceGenerators", index, removedSequenceGenerator);
        this.xmlEntityMappings.getSequenceGenerators().remove(index);
    }

    protected void removeSequenceGenerator_(OrmSequenceGenerator sequenceGenerator) {
        this.removeItemFromList(sequenceGenerator, this.sequenceGenerators, "sequenceGenerators");
    }

    @Override
    public void moveSequenceGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.sequenceGenerators, (int)targetIndex, (int)sourceIndex);
        this.xmlEntityMappings.getSequenceGenerators().move(targetIndex, sourceIndex);
        this.fireItemMoved("sequenceGenerators", targetIndex, sourceIndex);
    }

    protected XmlSequenceGenerator buildResourceSequenceGenerator() {
        return OrmFactory.eINSTANCE.createXmlSequenceGenerator();
    }

    @Override
    public ListIterable<OrmTableGenerator> getTableGenerators() {
        return new LiveCloneListIterable(this.tableGenerators);
    }

    @Override
    public int getTableGeneratorsSize() {
        return this.tableGenerators.size();
    }

    @Override
    public OrmTableGenerator addTableGenerator(int index) {
        XmlTableGenerator resourceTableGenerator = this.buildResourceTableGenerator();
        OrmTableGenerator contextTableGenerator = this.buildTableGenerator(resourceTableGenerator);
        this.tableGenerators.add(index, contextTableGenerator);
        this.xmlEntityMappings.getTableGenerators().add(index, (Object)resourceTableGenerator);
        this.fireItemAdded("tableGenerators", index, contextTableGenerator);
        return contextTableGenerator;
    }

    protected void addTableGenerator(int index, OrmTableGenerator tableGenerator) {
        this.addItemToList(index, tableGenerator, this.tableGenerators, "tableGenerators");
    }

    protected void addTableGenerator(OrmTableGenerator tableGenerator) {
        this.addTableGenerator(this.tableGenerators.size(), tableGenerator);
    }

    @Override
    public void removeTableGenerator(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator(this.tableGenerators.indexOf(tableGenerator));
    }

    @Override
    public void removeTableGenerator(int index) {
        OrmTableGenerator removedTableGenerator = this.tableGenerators.remove(index);
        this.xmlEntityMappings.getTableGenerators().remove(index);
        this.fireItemRemoved("tableGenerators", index, removedTableGenerator);
    }

    protected void removeTableGenerator_(OrmTableGenerator tableGenerator) {
        this.removeItemFromList(tableGenerator, this.tableGenerators, "tableGenerators");
    }

    @Override
    public void moveTableGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.tableGenerators, (int)targetIndex, (int)sourceIndex);
        this.xmlEntityMappings.getTableGenerators().move(targetIndex, sourceIndex);
        this.fireItemMoved("tableGenerators", targetIndex, sourceIndex);
    }

    protected XmlTableGenerator buildResourceTableGenerator() {
        return OrmFactory.eINSTANCE.createXmlTableGenerator();
    }

    @Override
    public OrmQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    @Override
    public OrmPersistenceUnitDefaults getPersistenceUnitDefaults() {
        return this.persistenceUnitMetadata.getPersistenceUnitDefaults();
    }

    protected void initializePersistentTypes() {
        for (XmlTypeMapping typeMapping : this.xmlEntityMappings.getTypeMappings()) {
            this.addPersistentType(typeMapping);
        }
    }

    protected void initializeTableGenerators() {
        for (XmlTableGenerator tableGenerator : this.xmlEntityMappings.getTableGenerators()) {
            this.tableGenerators.add(this.buildTableGenerator(tableGenerator));
        }
    }

    protected void initializeSequenceGenerators() {
        for (XmlSequenceGenerator sequenceGenerator : this.xmlEntityMappings.getSequenceGenerators()) {
            this.sequenceGenerators.add(this.buildSequenceGenerator(sequenceGenerator));
        }
    }

    @Override
    public void update() {
        this.setDescription(this.xmlEntityMappings.getDescription());
        this.setPackage(this.xmlEntityMappings.getPackage());
        this.setDefaultAccess(this.getPersistenceUnit().getDefaultAccess());
        this.setSpecifiedAccess(this.getResourceAccess());
        this.setDefaultCatalog(this.getPersistenceUnit().getDefaultCatalog());
        this.setSpecifiedCatalog(this.xmlEntityMappings.getCatalog());
        this.setDefaultSchema(this.getPersistenceUnit().getDefaultSchema());
        this.setSpecifiedSchema(this.xmlEntityMappings.getSchema());
        this.persistenceUnitMetadata.update();
        this.updatePersistentTypes();
        this.updateTableGenerators();
        this.updateSequenceGenerators();
        this.getQueryContainer().update();
    }

    protected AccessType getResourceAccess() {
        return AccessType.fromOrmResourceModel(this.xmlEntityMappings.getAccess());
    }

    protected void updatePersistentTypes() {
        HashBag contextTypesToRemove = CollectionTools.collection(this.persistentTypes());
        ArrayList<OrmPersistentType> contextTypesToUpdate = new ArrayList<OrmPersistentType>();
        int resourceIndex = 0;
        List<XmlTypeMapping> xmlTypeMappings = this.xmlEntityMappings.getTypeMappings();
        XmlTypeMapping[] xmlTypeMappingArray = xmlTypeMappings.toArray(new XmlTypeMapping[xmlTypeMappings.size()]);
        int n = xmlTypeMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlTypeMapping xmlTypeMapping = xmlTypeMappingArray[n2];
            boolean contextAttributeFound = false;
            for (OrmPersistentType contextType : contextTypesToRemove) {
                if (contextType.getMapping().getResourceTypeMapping() != xmlTypeMapping) continue;
                this.movePersistentType_(resourceIndex, contextType);
                contextTypesToRemove.remove(contextType);
                contextTypesToUpdate.add(contextType);
                contextAttributeFound = true;
                break;
            }
            if (!contextAttributeFound) {
                OrmPersistentType ormPersistentType = this.addPersistentType(xmlTypeMapping);
                this.fireItemAdded("persistentTypes", this.getPersistentTypesSize(), ormPersistentType);
            }
            ++resourceIndex;
            ++n2;
        }
        for (OrmPersistentType contextType : contextTypesToRemove) {
            this.removePersistentType_(contextType);
        }
        for (OrmPersistentType contextType : contextTypesToUpdate) {
            contextType.update();
        }
    }

    protected OrmPersistentType addPersistentType(XmlTypeMapping resourceMapping) {
        OrmPersistentType ormPersistentType = this.buildPersistentType(resourceMapping);
        this.persistentTypes.add(ormPersistentType);
        return ormPersistentType;
    }

    protected void updateTableGenerators() {
        CloneIterator xmlGenerators = new CloneIterator(this.xmlEntityMappings.getTableGenerators());
        for (OrmTableGenerator contextGenerator : this.getTableGenerators()) {
            if (xmlGenerators.hasNext()) {
                contextGenerator.update((XmlTableGenerator)xmlGenerators.next());
                continue;
            }
            this.removeTableGenerator_(contextGenerator);
        }
        while (xmlGenerators.hasNext()) {
            this.addTableGenerator(this.buildTableGenerator((XmlTableGenerator)xmlGenerators.next()));
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator resourceTableGenerator) {
        return this.getXmlContextNodeFactory().buildOrmTableGenerator(this, resourceTableGenerator);
    }

    protected void updateSequenceGenerators() {
        CloneIterator xmlSequenceGenerators = new CloneIterator(this.xmlEntityMappings.getSequenceGenerators());
        for (OrmSequenceGenerator contextSequenceGenerator : this.getSequenceGenerators()) {
            if (xmlSequenceGenerators.hasNext()) {
                contextSequenceGenerator.update((XmlSequenceGenerator)xmlSequenceGenerators.next());
                continue;
            }
            this.removeSequenceGenerator_(contextSequenceGenerator);
        }
        while (xmlSequenceGenerators.hasNext()) {
            this.addSequenceGenerator(this.buildSequenceGenerator((XmlSequenceGenerator)xmlSequenceGenerators.next()));
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator resourceSequenceGenerator) {
        return this.getXmlContextNodeFactory().buildOrmSequenceGenerator(this, resourceSequenceGenerator);
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        for (PersistentType persistentType : this.getPersistentTypes()) {
            persistentType.postUpdate();
        }
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentType persistentType : this.getPersistentTypes()) {
            if (!persistentType.contains(textOffset)) continue;
            return persistentType.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlEntityMappings != null && this.xmlEntityMappings.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlEntityMappings.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        this.validateGenerators(messages);
        this.queryContainer.validate(messages, reporter);
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            this.validatePersistentType(ormPersistentType, messages, reporter);
        }
    }

    protected void validateVersion(List<IMessage> messages) {
        if (!this.latestDocumentVersion().equals(this.xmlEntityMappings.getVersion())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "XML_VERSION_NOT_LATEST", this, this.xmlEntityMappings.getVersionTextRange()));
        }
    }

    protected abstract String latestDocumentVersion();

    protected void validateGenerators(List<IMessage> messages) {
        for (OrmGenerator localGenerator : this.getGenerators()) {
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().generators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange()));
            }
        }
    }

    protected Iterable<OrmGenerator> getGenerators() {
        return new CompositeIterable(new Iterable[]{this.getTableGenerators(), this.getSequenceGenerators()});
    }

    protected void validatePersistentType(OrmPersistentType persistentType, List<IMessage> messages, IReporter reporter) {
        try {
            persistentType.validate(messages, reporter);
        }
        catch (Throwable exception) {
            JptCorePlugin.log(exception);
        }
    }

    @Override
    public void dispose() {
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            ormPersistentType.dispose();
        }
    }
}

