/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.BreakpointLocationFinder;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.StepIntoSelectionUtils;

public class RunToLineAdapter
implements IRunToLineTarget {
    private static final String RUN_TO_LINE = "org.eclipse.wst.jsdt.debug.ui.run_to_line";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        ITextEditor textEditor = StepIntoSelectionUtils.getTextEditor(part);
        if (textEditor == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.missing_doc, null));
        }
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.empty_editor, null));
        }
        final IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.missing_doc, null));
        }
        final int[] validLine = new int[1];
        final String[] typeName = new String[1];
        final int[] lineNumber = new int[1];
        final ITextSelection textSelection = (ITextSelection)selection;
        Runnable r = new Runnable(){

            public void run() {
                lineNumber[0] = textSelection.getStartLine() + 1;
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(document.get().toCharArray());
                JavaScriptUnit compilationUnit = (JavaScriptUnit)parser.createAST(null);
                BreakpointLocationFinder locator = new BreakpointLocationFinder(compilationUnit, lineNumber[0], false);
                compilationUnit.accept((ASTVisitor)locator);
                validLine[0] = locator.getLineNumber();
                typeName[0] = locator.getFunctionName();
            }
        };
        BusyIndicator.showWhile((Display)JavaScriptDebugUIPlugin.getStandardDisplay(), (Runnable)r);
        if (validLine[0] == lineNumber[0]) {
            IJavaScriptLineBreakpoint breakpoint = null;
            HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(4);
            attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
            attributes.put(RUN_TO_LINE, Boolean.TRUE);
            breakpoint = JavaScriptDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (int)lineNumber[0], (int)-1, (int)-1, attributes, (boolean)false);
            if (target instanceof IAdaptable) {
                IDebugTarget debugTarget;
                IAdaptable iAdaptable = (IAdaptable)target;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((debugTarget = (IDebugTarget)iAdaptable.getAdapter((Class)clazz)) == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.cannot_find_debug_target, null));
                }
                RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)breakpoint);
                handler.run((IProgressMonitor)new NullProgressMonitor());
                return;
            }
        } else {
            if (textSelection.getLength() > 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.selected_line_not_valid, null));
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.cursor_position_not_valid, null));
        }
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IDebugElement) {
            IJavaScriptDebugTarget adapter;
            IDebugElement element = (IDebugElement)target;
            IDebugTarget iDebugTarget = element.getDebugTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.debug.core.model.IJavaScriptDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (adapter = (IJavaScriptDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null;
        }
        return false;
    }
}

