/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.jpa1.context.orm.GenericOrmReferenceTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlReferenceTable;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinTable
extends GenericOrmReferenceTable
implements OrmJoinTable {
    protected OrmJoinColumn defaultInverseJoinColumn;
    protected final Vector<OrmJoinColumn> specifiedInverseJoinColumns = new Vector();
    protected final OrmJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();

    public GenericOrmJoinTable(OrmJoinTableJoiningStrategy parent, XmlJoinTable resourceJoinTable) {
        super(parent);
        this.initialize(resourceJoinTable);
    }

    @Override
    protected OrmJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected OrmJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getParent().getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public void initializeFrom(JoinTable oldJoinTable) {
        super.initializeFrom(oldJoinTable);
        ListIterator stream = oldJoinTable.specifiedInverseJoinColumns();
        while (stream.hasNext()) {
            this.addSpecifiedInverseJoinColumnFrom((OrmJoinColumn)stream.next());
        }
    }

    protected void initialize(XmlJoinTable joinTable) {
        super.initialize(joinTable);
        this.initializeSpecifiedInverseJoinColumns(joinTable);
        this.initializeDefaultInverseJoinColumn();
    }

    @Override
    protected void update(AbstractXmlReferenceTable joinTable) {
        super.update(joinTable);
        this.updateSpecifiedInverseJoinColumns((XmlJoinTable)joinTable);
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    public OrmJoinTableJoiningStrategy getParent() {
        return (OrmJoinTableJoiningStrategy)super.getParent();
    }

    @Override
    protected String buildDefaultName() {
        return this.getParent().getJoinTableDefaultName();
    }

    @Override
    protected XmlJoinTable getResourceTable() {
        return this.getParent().getResourceJoinTable();
    }

    @Override
    protected XmlJoinTable addResourceTable() {
        return this.getParent().addResourceJoinTable();
    }

    @Override
    protected void removeResourceTable() {
        this.getParent().removeResourceJoinTable();
    }

    @Override
    public ListIterator<OrmJoinColumn> inverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumns() : this.defaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedInverseJoinColumn() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    @Override
    public OrmJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmJoinColumn defaultInverseJoinColumn) {
        OrmJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = defaultInverseJoinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, defaultInverseJoinColumn);
    }

    protected ListIterator<OrmJoinColumn> defaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultInverseJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void initializeDefaultInverseJoinColumn() {
        if (this.shouldBuildDefaultInverseJoinColumn()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
        }
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.shouldBuildDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(null));
            } else {
                this.defaultInverseJoinColumn.update(null);
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean shouldBuildDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedInverseJoinColumns() {
        return new CloneListIterator(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return !this.specifiedInverseJoinColumns.isEmpty();
    }

    protected void addSpecifiedInverseJoinColumnFrom(OrmJoinColumn oldJoinColumn) {
        OrmJoinColumn newJoinColumn = this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size());
        newJoinColumn.initializeFrom(oldJoinColumn);
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn(int index) {
        if (this.getResourceTable() == null) {
            this.addResourceTable();
        }
        XmlJoinColumn xmlJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumn();
        OrmJoinColumn joinColumn = this.buildInverseJoinColumn(xmlJoinColumn);
        this.specifiedInverseJoinColumns.add(index, joinColumn);
        this.getResourceTable().getInverseJoinColumns().add(index, (Object)xmlJoinColumn);
        this.fireItemAdded("specifiedInverseJoinColumns", index, joinColumn);
        return joinColumn;
    }

    protected void addSpecifiedInverseJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected void addSpecifiedInverseJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedInverseJoinColumns.remove(index);
        if (!this.hasSpecifiedInverseJoinColumns()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
        }
        this.getResourceTable().getInverseJoinColumns().remove(index);
        this.fireItemRemoved("specifiedInverseJoinColumns", index, removedJoinColumn);
        if (this.defaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
        }
    }

    protected void removeSpecifiedInverseJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedInverseJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().getInverseJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedInverseJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumns.clear();
        this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
        this.getResourceTable().getInverseJoinColumns().clear();
        this.fireListCleared("specifiedInverseJoinColumns");
        this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
    }

    protected OrmJoinColumn buildInverseJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.buildJoinColumn(resourceJoinColumn, this.inverseJoinColumnOwner);
    }

    protected void initializeSpecifiedInverseJoinColumns(XmlJoinTable xmlJoinTable) {
        if (xmlJoinTable != null) {
            for (XmlJoinColumn xmlJoinColumn : xmlJoinTable.getInverseJoinColumns()) {
                this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(xmlJoinColumn));
            }
        }
    }

    protected void updateSpecifiedInverseJoinColumns(XmlJoinTable xmlJoinTable) {
        Iterator<XmlJoinColumn> xmlJoinColumns = this.xmlInverseJoinColumns(xmlJoinTable);
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedInverseJoinColumns();
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn contextColumn = contextJoinColumns.next();
            if (xmlJoinColumns.hasNext()) {
                contextColumn.update(xmlJoinColumns.next());
                continue;
            }
            this.removeSpecifiedInverseJoinColumn_(contextColumn);
        }
        while (xmlJoinColumns.hasNext()) {
            this.addSpecifiedInverseJoinColumn(this.buildInverseJoinColumn(xmlJoinColumns.next()));
        }
    }

    protected Iterator<XmlJoinColumn> xmlInverseJoinColumns(XmlJoinTable xmlJoinTable) {
        return xmlJoinTable == null ? EmptyIterator.instance() : new CloneIterator(xmlJoinTable.getInverseJoinColumns());
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        super.validateJoinColumns(messages, reporter);
        this.validateJoinColumns(this.inverseJoinColumns(), messages, reporter);
    }

    @Override
    protected boolean shouldValidateAgainstDatabase() {
        return this.getParent().shouldValidateAgainstDatabase();
    }

    @Override
    protected String getUnresolvedCatalogMessageId() {
        return "JOIN_TABLE_UNRESOLVED_CATALOG";
    }

    @Override
    protected String getUnresolvedNameMessageId() {
        return "JOIN_TABLE_UNRESOLVED_NAME";
    }

    @Override
    protected String getUnresolvedSchemaMessageId() {
        return "JOIN_TABLE_UNRESOLVED_SCHEMA";
    }

    @Override
    protected String getVirtualAttributeUnresolvedCatalogMessageId() {
        return "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG";
    }

    @Override
    protected String getVirtualAttributeUnresolvedNameMessageId() {
        return "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME";
    }

    @Override
    protected String getVirtualAttributeUnresolvedSchemaMessageId() {
        return "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements OrmJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericOrmJoinTable.this.getParent().getRelationshipReference().getTypeMapping();
        }

        @Override
        public PersistentAttribute getPersistentAttribute() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getPersistentAttribute();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return !StringTools.stringsAreEqual((String)this.getDefaultTableName(), (String)tableName);
        }

        public boolean tableIsAllowed() {
            return false;
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public Table getDbTable(String tableName) {
            String joinTableName = GenericOrmJoinTable.this.getName();
            return joinTableName == null ? null : (joinTableName.equals(tableName) ? GenericOrmJoinTable.this.getDbTable() : null);
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmJoinTable.this.getValidationTextRange();
        }

        protected boolean isPersistentAttributeVirtual() {
            return this.getPersistentAttribute().isVirtual();
        }

        protected String getPersistentAttributeName() {
            return this.getPersistentAttribute().getName();
        }

        @Override
        public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
            if (this.isPersistentAttributeVirtual()) {
                return this.buildVirtualTableNotValidMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getTableNotValidMessage(), new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualTableNotValidMessage(BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualTableNotValidMessage(), new String[]{GenericOrmJoinTable.this.getName(), column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE}, column, textRange);
        }

        protected abstract String getTableNotValidMessage();

        protected abstract String getVirtualTableNotValidMessage();

        @Override
        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            if (this.isPersistentAttributeVirtual()) {
                return this.buildVirtualUnresolvedNameMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedNameMessage(), new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualUnresolvedNameMessage(), new String[]{this.getPersistentAttributeName(), column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected abstract String getUnresolvedNameMessage();

        protected abstract String getVirtualUnresolvedNameMessage();

        @Override
        public IMessage buildUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
            if (this.isPersistentAttributeVirtual()) {
                return this.buildVirtualUnresolvedReferencedColumnNameMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedReferencedColumnNameMessage(), new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualUnresolvedReferencedColumnNameMessage(), new String[]{this.getPersistentAttributeName(), column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected abstract String getUnresolvedReferencedColumnNameMessage();

        protected abstract String getVirtualUnresolvedReferencedColumnNameMessage();

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            if (this.isPersistentAttributeVirtual()) {
                return this.buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnspecifiedNameMultipleJoinColumnsMessage(), new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualUnspecifiedNameMultipleJoinColumnsMessage(), new String[]{this.getPersistentAttributeName()}, column, textRange);
        }

        protected abstract String getUnspecifiedNameMultipleJoinColumnsMessage();

        protected abstract String getVirtualUnspecifiedNameMultipleJoinColumnsMessage();

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            if (this.isPersistentAttributeVirtual()) {
                return this.buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(), new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(), new String[]{this.getPersistentAttributeName()}, column, textRange);
        }

        protected abstract String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();

        protected abstract String getVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.inverseJoinColumnsSize();
        }

        protected String getTableNotValidMessage() {
            return "INVERSE_JOIN_COLUMN_TABLE_NOT_VALID";
        }

        public String getVirtualTableNotValidMessage() {
            return "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID";
        }

        public String getUnresolvedNameMessage() {
            return "INVERSE_JOIN_COLUMN_UNRESOLVED_NAME";
        }

        public String getVirtualUnresolvedNameMessage() {
            return "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME";
        }

        public String getUnresolvedReferencedColumnNameMessage() {
            return "INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME";
        }

        public String getVirtualUnresolvedReferencedColumnNameMessage() {
            return "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME";
        }

        public String getUnspecifiedNameMultipleJoinColumnsMessage() {
            return "INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        public String getVirtualUnspecifiedNameMultipleJoinColumnsMessage() {
            return "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        public String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
            return "INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        public String getVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
            return "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return GenericOrmJoinTable.this.getParent().getRelationshipReference().getEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            if (relationshipMapping == null) {
                return null;
            }
            Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            for (PersistentAttribute each : CollectionTools.iterable(targetEntity.getPersistentType().allAttributes())) {
                if (!each.getMapping().isOwnedBy(relationshipMapping)) continue;
                return each.getName();
            }
            return null;
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.joinColumnsSize();
        }

        protected String getTableNotValidMessage() {
            return "JOIN_COLUMN_TABLE_NOT_VALID";
        }

        public String getVirtualTableNotValidMessage() {
            return "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_TABLE_NOT_VALID";
        }

        protected String getUnresolvedNameMessage() {
            return "JOIN_COLUMN_UNRESOLVED_NAME";
        }

        protected String getVirtualUnresolvedNameMessage() {
            return "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME";
        }

        public String getUnresolvedReferencedColumnNameMessage() {
            return "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME";
        }

        public String getVirtualUnresolvedReferencedColumnNameMessage() {
            return "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME";
        }

        public String getUnspecifiedNameMultipleJoinColumnsMessage() {
            return "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        public String getVirtualUnspecifiedNameMultipleJoinColumnsMessage() {
            return "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        public String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
            return "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        public String getVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
            return "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }
    }
}

