/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.sse.ui.internal.Logger;

public class StructuredMarkerAnnotation
extends MarkerAnnotation
implements IAnnotationPresentation {
    private boolean fIsGrayed = false;
    String fAnnotationType = null;

    StructuredMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public final String getAnnotationType() {
        if (this.fAnnotationType == null) {
            this.initAnnotationType();
        }
        return this.fAnnotationType;
    }

    protected Image getImage(Display display) {
        Image image = null;
        String annotationType = this.getAnnotationType();
        if (annotationType == "org.eclipse.wst.sse.ui.temp.error") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        } else if (annotationType == "org.eclipse.wst.sse.ui.temp.warning") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        } else if (annotationType == "org.eclipse.wst.sse.ui.temp.info") {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        if (image != null && this.isGrayed()) {
            this.setImage(this.getGrayImage(display, image));
        } else {
            this.setImage(image);
        }
        return super.getImage(display);
    }

    private Image getGrayImage(Display display, Image image) {
        if (image != null) {
            String key = Integer.toString(image.hashCode());
            Image grayImage = JFaceResources.getImageRegistry().get(key);
            if (grayImage == null) {
                grayImage = new Image((Device)display, image, 2);
                JFaceResources.getImageRegistry().put(key, grayImage);
            }
            image = grayImage;
        }
        return image;
    }

    public final boolean isGrayed() {
        return this.fIsGrayed;
    }

    public final void setGrayed(boolean grayed) {
        this.fIsGrayed = grayed;
    }

    protected void initAnnotationType() {
        IMarker marker = this.getMarker();
        this.fAnnotationType = "org.eclipse.text.annotation.unknown";
        try {
            if (marker.exists() && marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                int severity = marker.getAttribute("severity", -1);
                switch (severity) {
                    case 2: {
                        this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.error";
                        break;
                    }
                    case 1: {
                        this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.warning";
                        break;
                    }
                    case 0: {
                        this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.info";
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }
}

