/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPTableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPForeignKeyWrapper
extends DTPDatabaseObjectWrapper<DTPTableWrapper>
implements ForeignKey {
    private final org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey;
    private DTPTableWrapper referencedTable;
    private LocalColumnPair[] columnPairs;
    private String defaultAttributeName;
    private boolean defaultAttributeNameCalculated = false;

    DTPForeignKeyWrapper(DTPTableWrapper baseTable, org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey) {
        super(baseTable);
        this.dtpForeignKey = dtpForeignKey;
    }

    @Override
    ICatalogObject getCatalogObject() {
        return (ICatalogObject)this.dtpForeignKey;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().foreignKeyChanged(this);
    }

    @Override
    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.getName()) + ": " + Arrays.asList(this.getColumnPairArray())));
    }

    @Override
    public String getName() {
        return this.dtpForeignKey.getName();
    }

    @Override
    public DTPTableWrapper getBaseTable() {
        return (DTPTableWrapper)this.parent;
    }

    @Override
    public synchronized DTPTableWrapper getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.getBaseTable().getTable((Table)this.dtpForeignKey.getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    @Override
    public boolean referencesSingleColumnPrimaryKey() {
        if (this.getColumnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().getPrimaryKeyColumnsSize() != 1) {
            return false;
        }
        return this.getColumnPair().getReferencedColumn() == this.getReferencedTable().getPrimaryKeyColumn();
    }

    @Override
    public Iterable<ForeignKey.ColumnPair> getColumnPairs() {
        return new ArrayIterable((Object[])this.getColumnPairArray());
    }

    @Override
    public LocalColumnPair getColumnPair() {
        LocalColumnPair[] pairs = this.getColumnPairArray();
        if (pairs.length != 1) {
            throw new IllegalStateException("multiple column pairs: " + pairs.length);
        }
        return pairs[0];
    }

    private Iterable<LocalColumnPair> getLocalColumnPairs() {
        return new ArrayIterable((Object[])this.getColumnPairArray());
    }

    private synchronized LocalColumnPair[] getColumnPairArray() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairArray();
        }
        return this.columnPairs;
    }

    private LocalColumnPair[] buildColumnPairArray() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> baseColumns = this.getDTPBaseColumns();
        int size = baseColumns.size();
        List<org.eclipse.datatools.modelbase.sql.tables.Column> refColumns = this.getDTPReferenceColumns();
        if (refColumns.size() != size) {
            throw new IllegalStateException(String.valueOf(this.getBaseTable().getName()) + '.' + this.getName() + " - mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        Object[] result = new LocalColumnPair[baseColumns.size()];
        int i = baseColumns.size();
        while (i-- > 0) {
            result[i] = new LocalColumnPair(this.getBaseTable().getColumn(baseColumns.get(i)), this.getBaseTable().getColumn(refColumns.get(i)));
        }
        return (LocalColumnPair[])ArrayTools.sort((Object[])result, ForeignKey.ColumnPair.BASE_COLUMN_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPBaseColumns() {
        return this.dtpForeignKey.getMembers();
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPReferenceColumns() {
        return this.dtpForeignKey.getUniqueConstraint().getMembers();
    }

    @Override
    public int getColumnPairsSize() {
        return this.getColumnPairArray().length;
    }

    @Override
    public Iterable<Column> getBaseColumns() {
        return new TransformationIterable<LocalColumnPair, Column>(this.getLocalColumnPairs()){

            protected Column transform(LocalColumnPair pair) {
                return pair.getBaseColumn();
            }
        };
    }

    boolean baseColumnsContains(Column column) {
        return CollectionTools.contains(this.getBaseColumns(), (Object)column);
    }

    @Override
    public Iterable<Column> getNonPrimaryKeyBaseColumns() {
        return new FilteringIterable<Column>(this.getBaseColumns()){

            protected boolean accept(Column column) {
                return !column.isPartOfPrimaryKey();
            }
        };
    }

    @Override
    public Iterable<Column> getReferencedColumns() {
        return new TransformationIterable<LocalColumnPair, Column>(this.getLocalColumnPairs()){

            protected Column transform(LocalColumnPair columnPair) {
                return columnPair.getReferencedColumn();
            }
        };
    }

    @Override
    public String getAttributeName() {
        String defaultName = this.getDefaultAttributeName();
        return defaultName != null ? defaultName : this.getNonDefaultAttributeName();
    }

    @Override
    public synchronized String getDefaultAttributeName() {
        if (!this.defaultAttributeNameCalculated) {
            this.defaultAttributeNameCalculated = true;
            this.defaultAttributeName = this.buildDefaultAttributeName();
        }
        return this.defaultAttributeName;
    }

    private String buildDefaultAttributeName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        LocalColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        return baseColName.substring(0, _index);
    }

    private String getNonDefaultAttributeName() {
        return this.getColumnPairsSize() == 1 ? this.getNonDefaultAttributeNameFromBaseColumn() : this.getReferencedTable().getName();
    }

    private String getNonDefaultAttributeNameFromBaseColumn() {
        int refLen;
        LocalColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        int len = baseColName.length();
        if (len > (refLen = refColName.length()) && baseColName.endsWith(refColName) && (len -= refLen) > 1 && baseColName.charAt(len - 1) == '_') {
            --len;
        }
        return baseColName.substring(0, len);
    }

    @Override
    public String getJoinColumnAnnotationIdentifier(String attributeName) {
        String baseColumnName = this.getColumnPair().getBaseColumn().getName();
        String defaultBaseColumnName = String.valueOf(attributeName) + '_' + this.getReferencedTable().getPrimaryKeyColumn().getName();
        return this.getDTPDriverAdapter().convertNameToIdentifier(baseColumnName, defaultBaseColumnName);
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.constraints.ForeignKey foreignKey) {
        return this.dtpForeignKey == foreignKey;
    }

    @Override
    synchronized void clear() {
        this.defaultAttributeNameCalculated = false;
        this.defaultAttributeName = null;
        this.columnPairs = null;
        this.referencedTable = null;
    }

    static class LocalColumnPair
    implements ForeignKey.ColumnPair {
        private final DTPColumnWrapper baseColumn;
        private final DTPColumnWrapper referencedColumn;

        LocalColumnPair(DTPColumnWrapper baseColumn, DTPColumnWrapper referencedColumn) {
            if (baseColumn == null || referencedColumn == null) {
                throw new NullPointerException();
            }
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public DTPColumnWrapper getBaseColumn() {
            return this.baseColumn;
        }

        public DTPColumnWrapper getReferencedColumn() {
            return this.referencedColumn;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }
    }
}

