/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaEEArtifactClassOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class AddJavaEEArtifactOperation
extends AbstractDataModelOperation {
    protected IModelProvider provider = ModelProviderManager.getModelProvider(this.getTargetProject());

    public AddJavaEEArtifactOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(final IProgressMonitor monitor, final IAdaptable info) throws ExecutionException {
        Runnable runnable = null;
        if (this.provider.validateEdit(null, null).isOK()) {
            runnable = new Runnable(){

                public void run() {
                    try {
                        AddJavaEEArtifactOperation.this.doExecute(monitor, info);
                    }
                    catch (ExecutionException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            };
            this.provider.modify(runnable, null);
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createClass();
        return OK_STATUS;
    }

    protected String createClass() {
        NewJavaEEArtifactClassOperation op = this.getNewClassOperation();
        try {
            IStatus status = op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (!status.isOK()) {
                J2EEPlugin.log(status);
            }
        }
        catch (Exception e) {
            J2EEPlugin.logError(e);
        }
        return this.getQualifiedClassName();
    }

    protected abstract NewJavaEEArtifactClassOperation getNewClassOperation();

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    public final String getQualifiedClassName() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String className = this.model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + "." + className;
        }
        return className;
    }
}

