/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.internal.services.dstore.ServiceResources;
import org.eclipse.rse.services.AbstractService;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.IDStoreService;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;

public abstract class AbstractDStoreService
extends AbstractService
implements IDStoreService {
    protected IDataStoreProvider _dataStoreProvider;
    protected DataElement _minerElement;
    protected DStoreStatusMonitor _statusMonitor;
    protected Map _cmdDescriptorMap;
    protected DataElement _initializeStatus;

    public AbstractDStoreService(IDataStoreProvider dataStoreProvider) {
        this._dataStoreProvider = dataStoreProvider;
        this._cmdDescriptorMap = new HashMap();
    }

    public DStoreStatusMonitor getStatusMonitor(DataStore dataStore) {
        if (this._statusMonitor == null || this._statusMonitor.getDataStore() != dataStore) {
            this._statusMonitor = new DStoreStatusMonitor(dataStore);
        }
        return this._statusMonitor;
    }

    public DataStore getDataStore() {
        return this._dataStoreProvider.getDataStore();
    }

    protected DataElement getMinerElement() {
        if (this._minerElement == null || this._minerElement.getDataStore() != this.getDataStore()) {
            this._minerElement = this.getMinerElement(this.getMinerId());
        }
        return this._minerElement;
    }

    protected DataElement getMinerElement(String id) {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            return ds.findMinerInformation(id);
        }
        return null;
    }

    protected DataElement[] dsQueryCommand(DataElement subject, String command, IProgressMonitor monitor) {
        return this.dsQueryCommand(subject, null, command, monitor);
    }

    protected DataElement[] dsQueryCommand(DataElement subject, ArrayList args, String command, IProgressMonitor monitor) {
        block4: {
            DataElement queryCmd = this.getCommandDescriptor(subject, command);
            DataStore ds = this.getDataStore();
            DStoreStatusMonitor smonitor = this.getStatusMonitor(ds);
            if (queryCmd != null && ds != null) {
                DataElement status = smonitor.getCommandStatus(queryCmd, subject);
                status = args != null ? ds.command(queryCmd, args, subject, true) : ds.command(queryCmd, subject, true);
                try {
                    smonitor.waitForUpdate(status, monitor);
                    int resultSize = subject.getNestedSize();
                    this.checkHostJVM();
                    List nested = subject.getNestedData();
                    if (nested != null) {
                        return nested.toArray(new DataElement[resultSize]);
                    }
                }
                catch (InterruptedException e) {
                    if (monitor == null || monitor.isCanceled()) break block4;
                    monitor.setCanceled(true);
                }
            }
        }
        return new DataElement[0];
    }

    protected List dsQueryCommandMulti(DataElement[] subjects, String[] commands, IProgressMonitor monitor) {
        return this.dsQueryCommandMulti(subjects, null, commands, monitor);
    }

    protected List dsQueryCommandMulti(DataElement[] subjects, ArrayList[] argses, String[] commands, IProgressMonitor monitor) {
        ArrayList<DataElement> statuses = new ArrayList<DataElement>();
        DataStore ds = this.getDataStore();
        DStoreStatusMonitor smonitor = this.getStatusMonitor(ds);
        int i = 0;
        while (i < subjects.length && !monitor.isCanceled()) {
            DataElement subject = subjects[i];
            DataElement queryCmd = this.getCommandDescriptor(subject, commands[i]);
            if (queryCmd != null && ds != null) {
                DataElement status = smonitor.getCommandStatus(queryCmd, subject);
                if (status == null) {
                    status = argses != null ? ds.command(queryCmd, argses[i], subject, true) : ds.command(queryCmd, subject, true);
                }
                statuses.add(status);
            }
            ++i;
        }
        ArrayList<DataElement[]> consolidatedResults = new ArrayList<DataElement[]>();
        int i2 = 0;
        while (i2 < statuses.size() && !monitor.isCanceled()) {
            block7: {
                DataElement status = (DataElement)statuses.get(i2);
                DataElement deObj = subjects[i2];
                try {
                    List nested;
                    smonitor.waitForUpdate(status, monitor);
                    if (!monitor.isCanceled() && smonitor.determineStatusDone(status) && (nested = deObj.getNestedData()) != null) {
                        consolidatedResults.add(nested.toArray(new DataElement[nested.size()]));
                    }
                }
                catch (InterruptedException e) {
                    if (monitor == null || monitor.isCanceled()) break block7;
                    monitor.setCanceled(true);
                }
            }
            ++i2;
        }
        return consolidatedResults;
    }

    protected DataElement dsStatusCommand(DataElement subject, ArrayList args, String command, IProgressMonitor monitor) {
        DataStore ds = this.getDataStore();
        DStoreStatusMonitor smonitor = this.getStatusMonitor(ds);
        DataElement queryCmd = this.getCommandDescriptor(subject, command);
        if (queryCmd != null && ds != null) {
            DataElement status;
            block4: {
                status = smonitor.getCommandStatus(queryCmd, subject);
                if (status == null) {
                    status = ds.command(queryCmd, args, subject, true);
                }
                try {
                    smonitor.waitForUpdate(status, monitor);
                }
                catch (InterruptedException e) {
                    if (monitor == null || monitor.isCanceled()) break block4;
                    monitor.setCanceled(true);
                }
            }
            return status;
        }
        return null;
    }

    protected DataElement dsStatusCommand(DataElement subject, String command, IProgressMonitor monitor) {
        DataStore ds = this.getDataStore();
        DStoreStatusMonitor smonitor = this.getStatusMonitor(ds);
        DataElement queryCmd = this.getCommandDescriptor(subject, command);
        if (queryCmd != null && ds != null) {
            DataElement status;
            block4: {
                status = smonitor.getCommandStatus(queryCmd, subject);
                if (status == null) {
                    status = ds.command(queryCmd, subject, true);
                }
                try {
                    smonitor.waitForUpdate(status, monitor);
                }
                catch (InterruptedException e) {
                    if (monitor == null || monitor.isCanceled()) break block4;
                    monitor.setCanceled(true);
                }
            }
            return status;
        }
        return null;
    }

    protected DataElement getCommandDescriptor(DataElement subject, String command) {
        DataStore ds = this.getDataStore();
        DataElement cmd = (DataElement)this._cmdDescriptorMap.get(command);
        if ((cmd == null || ds != cmd.getDataStore()) && ds != null) {
            cmd = ds.localDescriptorQuery(subject.getDescriptor(), command);
            this._cmdDescriptorMap.put(command, cmd);
        }
        return cmd;
    }

    public int getServerVersion() {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            return ds.getServerVersion();
        }
        return 0;
    }

    public int getServerMinor() {
        DataStore ds = this.getDataStore();
        if (ds != null) {
            return ds.getServerMinor();
        }
        return 0;
    }

    protected void checkHostJVM() {
    }

    public boolean isInitialized() {
        DataStore ds;
        if (this._initializeStatus != null && (ds = this.getDataStore()) != null) {
            DStoreStatusMonitor smon = this.getStatusMonitor(ds);
            return smon.determineStatusDone(this._initializeStatus);
        }
        return false;
    }

    protected void waitForInitialize(IProgressMonitor monitor) {
        DataStore ds;
        if (this._initializeStatus != null && (ds = this.getDataStore()) != null) {
            block3: {
                DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                try {
                    smon.waitForUpdate(this._initializeStatus, monitor, 100);
                }
                catch (InterruptedException e) {
                    if (monitor == null || monitor.isCanceled()) break block3;
                    monitor.setCanceled(true);
                }
            }
            this.getMinerElement();
        }
    }

    public void initService(IProgressMonitor monitor) throws SystemMessageException {
        super.initService(monitor);
        this.initMiner(monitor);
    }

    public void uninitService(IProgressMonitor monitor) {
        this._initializeStatus = null;
        this._cmdDescriptorMap.clear();
        this._minerElement = null;
        this._statusMonitor = null;
        super.uninitService(monitor);
    }

    protected void initMiner(IProgressMonitor monitor) {
        DataElement fsElement = this.getMinerElement();
        if (fsElement == null && this.getServerVersion() >= 8) {
            String minerId = this.getMinerId();
            String message = SystemMessage.sub((String)ServiceResources.DStore_Service_ProgMon_Initializing_Message, (String)"&1", (String)minerId);
            monitor.beginTask(message, -1);
            DataStore ds = this.getDataStore();
            if ((this._minerElement == null || this._minerElement.getDataStore() != ds) && ds != null && this._initializeStatus == null) {
                this._initializeStatus = ds.activateMiner(minerId);
            }
        }
        monitor.done();
    }

    protected abstract String getMinerId();
}

