/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.refactoring;

import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;

public class LSPTextChange
extends TextChange {
    private final @NonNull URI fileUri;
    private Either<IFile, IFileStore> file;
    private int fAcquireCount;
    private ITextFileBuffer fBuffer;
    private @NonNull String newText;
    private Range range;

    public LSPTextChange(@NonNull String name, @NonNull URI fileUri, @NonNull org.eclipse.lsp4j.TextEdit textEdit) {
        super(name);
        this.fileUri = fileUri;
        this.newText = textEdit.getNewText();
        this.range = textEdit.getRange();
    }

    public LSPTextChange(@NonNull String name, @NonNull URI fileUri, @NonNull String newText) {
        super(name);
        this.fileUri = fileUri;
        this.newText = newText;
        this.range = null;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        ++this.fAcquireCount;
        if (this.fAcquireCount > 1) {
            return this.fBuffer.getDocument();
        }
        IFile iFile = LSPEclipseUtils.getFileHandle(this.fileUri);
        this.file = iFile != null ? Either.forLeft((Object)iFile) : Either.forRight((Object)EFS.getStore((URI)this.fileUri));
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        this.fBuffer = this.file.isLeft() ? manager.getTextFileBuffer(((IFile)this.file.getLeft()).getFullPath(), LocationKind.IFILE) : manager.getFileStoreTextFileBuffer((IFileStore)this.file.getRight());
        if (this.fBuffer != null) {
            ++this.fAcquireCount;
        } else if (this.file.isLeft()) {
            manager.connect(((IFile)this.file.getLeft()).getFullPath(), LocationKind.IFILE, pm);
            this.fBuffer = manager.getTextFileBuffer(((IFile)this.file.getLeft()).getFullPath(), LocationKind.IFILE);
        } else {
            manager.connectFileStore((IFileStore)this.file.getRight(), pm);
            this.fBuffer = manager.getFileStoreTextFileBuffer((IFileStore)this.file.getRight());
        }
        IDocument document = this.fBuffer.getDocument();
        int offset = 0;
        int length = document.getLength();
        if (this.range != null) {
            try {
                offset = LSPEclipseUtils.toOffset(this.range.getStart(), document);
                length = LSPEclipseUtils.toOffset(this.range.getEnd(), document) - offset;
                this.setEdit((TextEdit)new ReplaceEdit(offset, length, this.newText));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return document;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        this.fBuffer.commit(pm, true);
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        Assert.isTrue((this.fAcquireCount > 0 ? 1 : 0) != 0);
        if (this.fAcquireCount == 1) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            this.fBuffer.commit(pm, true);
            if (this.file.isLeft()) {
                manager.disconnect(((IFile)this.file.getLeft()).getFullPath(), LocationKind.IFILE, pm);
            } else {
                manager.disconnectFileStore((IFileStore)this.file.getRight(), pm);
            }
        }
        --this.fAcquireCount;
    }

    protected Change createUndoChange(UndoEdit edit) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Object getModifiedElement() {
        IFile file = LSPEclipseUtils.getFileHandle(this.fileUri);
        if (file != null) {
            return file;
        }
        if (this.fBuffer != null) {
            return this.fBuffer.getDocument();
        }
        return null;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 3);
        IDocument document = null;
        try {
            document = this.acquireDocument((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
            int offset = 0;
            int length = document.getLength();
            if (this.range != null) {
                offset = LSPEclipseUtils.toOffset(this.range.getStart(), document);
                length = LSPEclipseUtils.toOffset(this.range.getEnd(), document) - offset;
            }
            Object delegate = this.file.isRight() ? new DocumentChange("Change in document " + this.fileUri.getPath(), document) : new TextFileChange("Change in file " + ((IFile)this.file.getLeft()).getName(), (IFile)this.file.getLeft()){

                protected boolean needsSaving() {
                    return LSPTextChange.this.fAcquireCount == 1;
                }
            };
            delegate.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            delegate.setEdit((TextEdit)new ReplaceEdit(offset, length, this.newText));
            Change change = delegate.perform(pm);
            return change;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException((BadLocationException)e);
        }
        catch (MalformedTreeException e) {
            throw Changes.asCoreException((MalformedTreeException)e);
        }
        finally {
            if (document != null) {
                this.releaseDocument(document, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
            }
            pm.done();
        }
    }
}

