/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#ifndef GNUMERIC_SHEET_OBJECT_PRIV_H
#define GNUMERIC_SHEET_OBJECT_PRIV_H

#include "sheet-object.h"
#include <glib-object.h>
#include <gtk/gtkmenu.h>
#include <libgnomeprint/gnome-print.h>

typedef enum {
	SHEET_OBJECT_ACTION_STATIC,
	SHEET_OBJECT_ACTION_CAN_PRESS
} SheetObjectAction;

struct _SheetObject {
	GObject            parent_object;
	SheetObjectAction  type;
	Sheet             *sheet;
	GList             *realized_list;
	SheetObjectAnchor  anchor;
	gboolean	   is_visible;
};

typedef struct {
	GObjectClass parent_class;

	/* signals */
	void (*unrealize) (SheetObject	*sheet_object);

	/* Virtual methods */
	gboolean (*remove_from_sheet) (SheetObject	*sheet_object);
	gboolean   (*assign_to_sheet) (SheetObject	*sheet_object,
				       Sheet		*sheet);

	GObject *      (*new_view)   (SheetObject	*sheet_object,
				      SheetControlGUI	*s_control);
	void        (*populate_menu) (SheetObject	*sheet_object,
				      GObject		*obj_view,
				      GtkMenu		*menu);
	void	      (*user_config) (SheetObject	*sheet_object,
				      SheetControlGUI	*s_control);
	void        (*update_bounds) (SheetObject	*so,
				      GObject		*obj_view,
				      SheetControlGUI	*s_control);
	void           (*set_active) (SheetObject	*so,
				      GObject           *obj_view,
				      gboolean		val);
	gboolean	 (*read_xml) (SheetObject	*so,
				      XmlParseContext const *ctxt,
				      xmlNodePtr	tree);
	gboolean	(*write_xml) (SheetObject const *so,
				      XmlParseContext const *ctxt,
				      xmlNodePtr	tree);
	void                (*print) (SheetObject const *so,
				      GnomePrintContext *ctx,
				      double base_x,
				      double base_y);
	SheetObject *       (*clone) (SheetObject const *so,
				      Sheet *sheet);

	double	 default_width_pts, default_height_pts;
	gboolean stipple_border;
	gboolean rubber_band_directly; /* If false, we draw a rectangle where
					* the object is going to be layed out
					* If true, we draw the object while
					* laying it out on the sheet
					*/
} SheetObjectClass;

#define SHEET_OBJECT_CLASS(k) (G_TYPE_CHECK_CLASS_CAST ((k), SHEET_OBJECT_TYPE, SheetObjectClass))

#endif /* GNUMERIC_SHEET_OBJECT_PRIV_H */
