/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * gog-axis.h : 
 *
 * Copyright (C) 2003 Jody Goldberg (jody@gnome.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
#ifndef GOG_AXIS_H
#define GOG_AXIS_H

#include <goffice/graph/goffice-graph.h>
#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
	GOG_AXIS_AT_LOW = -1,
	GOG_AXIS_IN_MIDDLE = 0,
	GOG_AXIS_AT_HIGH = 1
} GogAxisPosition;
typedef enum {
	GOG_AXIS_TICK_LEVEL_NONE = 0,
	GOG_AXIS_TICK_LEVEL_MAJOR,
	GOG_AXIS_TICK_LEVEL_MINOR
} GogAxisTickLevel;

#define GOG_AXIS_TYPE	(gog_axis_get_type ())
#define GOG_AXIS(o)	(G_TYPE_CHECK_INSTANCE_CAST ((o), GOG_AXIS_TYPE, GogAxis))
#define IS_GOG_AXIS(o)	(G_TYPE_CHECK_INSTANCE_TYPE ((o), GOG_AXIS_TYPE))

GType gog_axis_get_type (void);

void		gog_axis_add_contributor (GogAxis *axis, GogObject *contrib);
void		gog_axis_del_contributor (GogAxis *axis, GogObject *contrib);
void		gog_axis_bound_changed   (GogAxis *axis, GogObject *contrib,
					  double low, double high);
GogAxisType	gog_axis_type	 	 (GogAxis const *axis);
GogAxisPosition gog_axis_pos	 	 (GogAxis const *axis);

G_END_DECLS

#endif /* GOG_AXIS_H */
