/* A Bison parser, made from parser.y
   by GNU bison 1.35.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	STRING	257
# define	QUOTED_STRING	258
# define	CONSTANT	259
# define	CELLREF	260
# define	GTE	261
# define	LTE	262
# define	NE	263
# define	AND	264
# define	OR	265
# define	NOT	266
# define	SEPARATOR	267
# define	INVALID_TOKEN	268
# define	NEG	269
# define	PLUS	270
# define	RANGE_SEP	271
# define	SHEET_SEP	272

#line 1 "parser.y"

/*
 * Gnumeric Parser
 *
 * (C) 1998-2001 the Free Software Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 *    Jody Goldberg (jody@gnome.org)
 *    Morten Welinder (terra@diku.dk)
 *    Almer S. Tigelaar (almer@gnome.org)
 */
#include <gnumeric-config.h>
#include <gnumeric-i18n.h>
#include "gnumeric.h"
#include "number-match.h"
#include "expr.h"
#include "expr-impl.h"
#include "expr-name.h"
#include "workbook.h"
#include "sheet.h"
#include "format.h"
#include "application.h"
#include "parse-util.h"
#include "gutils.h"
#include "auto-format.h"
#include "style.h"
#include "value.h"
#include "str.h"

#include <string.h>
#include <errno.h>
#include <stdlib.h>

#define YYDEBUG 1
/* ------------------------------------------------------------------------- */
/* Allocation with disposal-on-error */

/*
 * Defined: the stack itself will be kept in use.  This isn't much, btw.
 *   This setting is good for speed.
 *
 * Not defined: memory will be freed.  The is good for finding leaks in the
 * program.  (Here and elsewhere.)
 */
#define KEEP_DEALLOCATION_STACK_BETWEEN_CALLS

/*
 * If some dork enters "=1+2+2*(1+" we have already allocated space for
 * "1+2", "2", and "1" before the parser sees the syntax error and warps
 * us to the error production in the "line" non-terminal.
 *
 * To make sure we can clean up, we register every allocation.  On success,
 * nothing should be left (except the final expression which is unregistered),
 * but on failure we must free everything allocated.
 *
 * Note: there is some room left for optimisation here.  Talk to terra@diku.dk
 * before you set out to do it.
 */

static void
free_expr_list_list (GSList *list)
{
	GSList *l;
	for (l = list; l; l = l->next)
		gnm_expr_list_unref (l->data);
	g_slist_free (list);
}

typedef void (*ParseDeallocator) (void *);
static GPtrArray *deallocate_stack;

static void
deallocate_init (void)
{
	deallocate_stack = g_ptr_array_new ();
}

static void
deallocate_uninit (void)
{
#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
	g_ptr_array_free (deallocate_stack, TRUE);
	deallocate_stack = NULL;
#endif
}

static void
deallocate_all (void)
{
	int i;

	for (i = 0; i < (int)deallocate_stack->len; i += 2) {
		ParseDeallocator freer = g_ptr_array_index (deallocate_stack, i + 1);
		freer (g_ptr_array_index (deallocate_stack, i));
	}

	g_ptr_array_set_size (deallocate_stack, 0);
}

static void
deallocate_assert_empty (void)
{
	if (deallocate_stack->len == 0)
		return;

	g_warning ("deallocate_stack not empty as expected.");
	deallocate_all ();
}

static void *
register_allocation (gpointer data, ParseDeallocator freer)
{
	/* It's handy to be able to register and unregister NULLs.  */
	if (data) {
		int len;
		/*
		 * There are really only a few different freers, so we
		 * could encode the freer in the lower bits of the data
		 * pointer.  Unfortunately, no-one can predict how high
		 * Miguel would jump when he found out.
		 */
		len = deallocate_stack->len;
		g_ptr_array_set_size (deallocate_stack, len + 2);
		g_ptr_array_index (deallocate_stack, len) = data;
		g_ptr_array_index (deallocate_stack, len + 1) = freer;
	}

	/* Returning the pointer here improved readability of the caller.  */
	return data;
}

#define register_expr_allocation(expr) \
  register_allocation ((gpointer)(expr), (ParseDeallocator)&gnm_expr_unref)

#define register_expr_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&gnm_expr_list_unref)

#define register_expr_list_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list_list)

static void
unregister_allocation (void const *data)
{
	int pos;

	/* It's handy to be able to register and unregister NULLs.  */
	if (!data)
		return;

	pos = deallocate_stack->len - 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	/*
	 * Bummer.  In certain error cases, it is possible that the parser
	 * will reduce after it has discovered a token that will lead to an
	 * error.  "2/16/1800 00:00" (without the quotes) is an example.
	 * The first "00" is registered before the second division is
	 * reduced.
	 *
	 * This isn't a big deal -- we will just look at the entry just below
	 * the top.
	 */
	pos -= 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_index (deallocate_stack, pos) =
			g_ptr_array_index (deallocate_stack, pos + 2);
		g_ptr_array_index (deallocate_stack, pos + 1) =
			g_ptr_array_index (deallocate_stack, pos + 3);

		g_ptr_array_set_size (deallocate_stack, pos + 2);
		return;
	}

	g_warning ("Unbalanced allocation registration");
}

/* ------------------------------------------------------------------------- */

#define ERROR -1

/* Bison/Yacc internals */
static int yylex (void);
static int yyerror (const char *s);

typedef struct {
	/* The expression being parsed */
	char const *expr_text;

	/* A backup of the above, this will always point to the real
	 * expression beginning to calculate the offset in the expression
	 */
	char const *expr_backup;

	/* Location where the parsing is taking place */
	ParsePos const *pos;

	/* Locale info. */
	gunichar decimal_point;
	gunichar separator;
	gunichar array_col_separator;

	/* flags */
	gboolean use_excel_reference_conventions;
	gboolean create_placeholder_for_unknown_func;
	gboolean force_absolute_col_references;
	gboolean force_absolute_row_references;
	gboolean force_explicit_sheet_references;

	/* The suggested format to use for this expression */
	GnmExprList *result;

	ParseError *error;
} ParserState;

/* The error returned from the */
static ParserState *state;

static GnmExpr *
build_unary_op (GnmExprOp op, GnmExpr *expr)
{
	unregister_allocation (expr);
	return register_expr_allocation (gnm_expr_new_unary (op, expr));
}

static GnmExpr *
build_binop (GnmExpr *l, GnmExprOp op, GnmExpr *r)
{
	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (gnm_expr_new_binary (l, op, r));
}

static GnmExpr *
build_logical (GnmExpr *l, gboolean is_and, GnmExpr *r)
{
	static FunctionDefinition *and_func = NULL, *or_func = NULL;

	if (and_func == NULL)
		and_func = func_lookup_by_name ("AND", NULL);
	if (or_func == NULL)
		or_func = func_lookup_by_name ("OR", NULL);

	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (gnm_expr_new_funcall (is_and ? and_func : or_func,
		    g_slist_prepend (g_slist_prepend (NULL, l), r)));
}

static GnmExpr *
build_not (GnmExpr *expr)
{
	static FunctionDefinition *not_func = NULL;
	if (not_func == NULL)
		not_func = func_lookup_by_name ("NOT", NULL);
	unregister_allocation (expr);
	return register_expr_allocation (gnm_expr_new_funcall (not_func,
		    g_slist_prepend (NULL, expr)));
}

static GnmExpr *
build_array (GSList *cols)
{
	Value *array;
	GSList *row;
	int x, mx, y;

	if (!cols) {
		/* parser_error = PARSE_ERR_SYNTAX; */
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = row->next;
	}

	array = value_new_array_empty (mx, g_slist_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			GnmExpr    *expr = row->data;
			Value const *v = expr->constant.value;

			g_assert (expr->any.oper == GNM_EXPR_OP_CONSTANT);

			value_array_set (array, x, y, value_duplicate (v));

			x++;
			row = row->next;
		}
		if (x < mx || row) {
			/* parser_error = PARSE_ERR_SYNTAX; */
			value_release (array);
			return NULL;
		}
		y++;
		cols = cols->next;
	}

	return register_expr_allocation (gnm_expr_new_constant (array));
}

/**
 * parse_string_as_value :
 *
 * Try to parse the entered text as a basic value (empty, bool, int,
 * float, err) if this succeeds, we store this as a Value otherwise, we
 * return a string.
 */
static GnmExpr *
parse_string_as_value (GnmExpr *str)
{
	Value *v = format_match_simple (value_peek_string (str->constant.value));

	if (v != NULL) {
		unregister_allocation (str);
		gnm_expr_unref (str);
		return register_expr_allocation (gnm_expr_new_constant (v));
	}
	return str;
}

/**
 * parse_string_as_value_or_name :
 * @str : An expression with oper constant, whose value is a string.
 *
 * Check to see if a string is a name
 * if it is not check to see if it can be parsed as a value
 */
static GnmExpr *
parse_string_as_value_or_name (GnmExpr *str)
{
	GnmNamedExpr *expr_name;

	expr_name = expr_name_lookup (state->pos, str->constant.value->v_str.val->str);
	if (expr_name != NULL) {
		unregister_allocation (str);
		gnm_expr_unref (str);
		return register_expr_allocation (gnm_expr_new_name (expr_name, NULL, NULL));
	}

	return parse_string_as_value (str);
}

static int
gnumeric_parse_error (ParserState *state, ParseErrorID id, char *message, int end, int relative_begin)
{
	if (state->error != NULL) {
		state->error->id         = id;
		state->error->message    = message;
		state->error->begin_char = (end - relative_begin);
		state->error->end_char   = end;
	} else
		g_free (message);

	return ERROR;
}

static gboolean
force_explicit_sheet_references (ParserState *state, CellRef *ref)
{
	ref->sheet = state->pos->sheet;
	if (ref->sheet != NULL)
		return FALSE;

	gnumeric_parse_error (
		state, PERR_SHEET_IS_REQUIRED,
		g_strdup (_("Sheet name is required")),
		state->expr_text - state->expr_backup, 0);
	return TRUE;
}

static Sheet *
parser_sheet_by_name (Workbook *wb, GnmExpr *name_expr)
{
	char  *name = name_expr->constant.value->v_str.val->str;
	Sheet *sheet = NULL;
	
	if (wb == NULL)
		return NULL;
	
	sheet = workbook_sheet_by_name (wb, name);

	/* Applix has absolute and relative sheet references */
	if (sheet == NULL &&
	    !state->use_excel_reference_conventions && *name == '$')
		sheet = workbook_sheet_by_name (wb, name+1);

	if (sheet == NULL) {
		gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), name),
				state->expr_text - state->expr_backup, strlen (name));
	}
	return sheet;
}

/* Make byacc happier */
int yyparse (void);


#line 412 "parser.y"
#ifndef YYSTYPE
typedef union {
	GnmExpr		*expr;
	Value		*value;
	CellRef		*cell;
	GnmExprList	*list;
	struct {
		Sheet	*first;
		Sheet	*last;
	} sheet;
} yystype;
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif
#ifndef YYDEBUG
# define YYDEBUG 0
#endif



#define	YYFINAL		99
#define	YYFLAG		-32768
#define	YYNTBASE	37

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 272 ? yytranslate[x] : 49)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    28,    15,     2,
      29,    30,    21,    20,     2,    19,     2,    22,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    36,
      16,    18,    17,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    33,    35,    34,    27,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    31,     2,    32,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    23,
      24,    25,    26
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     3,     5,     9,    10,    12,    14,    16,    18,
      22,    26,    30,    34,    38,    42,    46,    50,    54,    58,
      62,    66,    70,    74,    78,    81,    84,    87,    90,    94,
      96,    99,   104,   109,   111,   113,   116,   122,   124,   125,
     127,   130,   134,   140,   144,   148,   152,   154,   158,   161,
     162,   164,   166,   168,   172,   176,   177,   179
};
static const short yyrhs[] =
{
      38,    39,     0,     1,     0,    38,    39,    13,     0,     0,
       5,     0,     4,     0,     3,     0,    44,     0,    39,    20,
      39,     0,    39,    19,    39,     0,    39,    21,    39,     0,
      39,    22,    39,     0,    39,    27,    39,     0,    39,    15,
      39,     0,    39,    18,    39,     0,    39,    16,    39,     0,
      39,    17,    39,     0,    39,     7,    39,     0,    39,     9,
      39,     0,    39,     8,    39,     0,    39,    10,    39,     0,
      39,    11,    39,     0,    29,    39,    30,     0,    19,    39,
       0,    20,    39,     0,    12,    39,     0,    39,    28,     0,
      31,    48,    32,     0,    40,     0,    42,    41,     0,    33,
      41,    34,    41,     0,     3,    29,    45,    30,     0,     3,
       0,     4,     0,    41,    26,     0,    33,    41,    34,    41,
      26,     0,    42,     0,     0,     6,     0,    42,     6,     0,
       6,    25,     6,     0,    42,     6,    25,    43,     6,     0,
       6,    25,    40,     0,    40,    25,    40,     0,    40,    25,
       6,     0,    39,     0,    39,    13,    45,     0,    13,    45,
       0,     0,     5,     0,    41,     0,    46,     0,    46,    13,
      47,     0,    46,    35,    47,     0,     0,    47,     0,    47,
      36,    48,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,   439,   445,   453,   459,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   482,   483,   484,   485,   487,   493,
     494,   523,   562,   583,   584,   587,   596,   611,   612,   615,
     625,   639,   659,   677,   678,   679,   682,   687,   693,   703,
     706,   707,   710,   715,   728,   742,   745,   750
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "STRING", "QUOTED_STRING", "CONSTANT", 
  "CELLREF", "GTE", "LTE", "NE", "AND", "OR", "NOT", "SEPARATOR", 
  "INVALID_TOKEN", "'&'", "'<'", "'>'", "'='", "'-'", "'+'", "'*'", "'/'", 
  "NEG", "PLUS", "RANGE_SEP", "SHEET_SEP", "'^'", "'%'", "'('", "')'", 
  "'{'", "'}'", "'['", "']'", "'\\\\'", "';'", "line", "opt_exp", "exp", 
  "function", "string_opt_quote", "sheetref", "opt_sheetref", "cellref", 
  "arg_list", "array_exp", "array_row", "array_cols", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    37,    37,    38,    38,    39,    39,    39,    39,    39,
      39,    39,    39,    39,    39,    39,    39,    39,    39,    39,
      39,    39,    39,    39,    39,    39,    39,    39,    39,    39,
      39,    39,    40,    41,    41,    42,    42,    43,    43,    44,
      44,    44,    44,    44,    44,    44,    45,    45,    45,    45,
      46,    46,    47,    47,    47,    47,    48,    48
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     2,     1,     3,     0,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     2,     2,     3,     1,
       2,     4,     4,     1,     1,     2,     5,     1,     0,     1,
       2,     3,     5,     3,     3,     3,     1,     3,     2,     0,
       1,     1,     1,     3,     3,     0,     1,     3
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       0,     2,     0,     7,     6,     5,    39,     0,     0,     0,
       0,    55,     0,     1,    29,     0,     0,     8,    49,     0,
      26,    24,    25,     0,    33,    34,    50,    51,    52,    56,
       0,     0,     0,     0,     0,     0,     0,     3,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    27,     0,    35,
      40,    30,    49,    46,     0,     0,    41,    43,    23,    55,
      55,    55,    28,     0,    18,    20,    19,    21,    22,    14,
      16,    17,    15,    10,     9,    11,    12,    13,    45,    44,
      38,    48,    49,    32,    53,    54,    57,    31,     0,    37,
       0,    47,    36,     0,    42,     0,     0,     0,     0,     0
};

static const short yydefgoto[] =
{
      97,     2,    53,    14,    15,    16,    90,    17,    54,    28,
      29,    30
};

static const short yypact[] =
{
      50,-32768,    87,   -14,   -22,-32768,   -19,    87,    87,    87,
      87,    56,    60,   138,    -9,   -15,    16,-32768,    82,    18,
       3,     3,     3,   114,-32768,-32768,-32768,-32768,   -10,    -8,
       5,    33,    87,    87,    87,    87,    87,-32768,    87,    87,
      87,    87,    87,    87,    87,    87,    87,-32768,    20,-32768,
      43,-32768,    82,   160,    41,    44,-32768,-32768,-32768,    56,
      56,    56,-32768,    60,   186,   186,   186,    46,    46,   182,
     186,   186,   186,   201,   201,     3,     3,     3,-32768,-32768,
      14,-32768,    82,-32768,-32768,-32768,-32768,    49,    60,-32768,
      66,-32768,-32768,    42,-32768,    60,    49,    78,    80,-32768
};

static const short yypgoto[] =
{
  -32768,-32768,     0,    10,   -11,     2,-32768,-32768,   -25,-32768,
       6,    28
};


#define	YYLAST		229


static const short yytable[] =
{
      27,    31,    13,    59,   -34,    51,    19,    20,    21,    22,
      23,    49,   -33,    35,    36,    18,    48,    24,    25,    24,
      25,    55,    50,    55,    56,    60,    78,    81,    61,    57,
      46,    47,    64,    65,    66,    67,    68,    62,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    88,    27,    27,
      27,     1,    87,    -4,    -4,    -4,    -4,    91,    79,    24,
      25,    26,    -4,    24,    25,    84,    85,    63,    80,    -4,
      -4,    83,    94,    18,    47,    92,    95,    93,    98,    -4,
      99,    -4,    89,    -4,    96,     3,     4,     5,     6,    86,
       3,     4,     5,     6,     7,    52,     0,     0,     0,     7,
       0,     8,     9,     0,     0,     0,     8,     9,     0,     0,
       0,    10,     0,    11,     0,    12,    10,     0,    11,     0,
      12,    32,    33,    34,    35,    36,     0,     0,     0,    38,
      39,    40,    41,    42,    43,    44,    45,     0,     0,     0,
       0,    46,    47,     0,    58,    32,    33,    34,    35,    36,
       0,    37,     0,    38,    39,    40,    41,    42,    43,    44,
      45,     0,     0,     0,     0,    46,    47,    32,    33,    34,
      35,    36,     0,    82,     0,    38,    39,    40,    41,    42,
      43,    44,    45,     0,     0,     0,     0,    46,    47,    32,
      33,    34,    35,    36,     0,     0,    35,    36,    39,    40,
      41,    42,    43,    44,    45,    42,    43,    44,    45,    46,
      47,    35,    36,    46,    47,     0,     0,     0,     0,     0,
       0,     0,    44,    45,     0,     0,     0,     0,    46,    47
};

static const short yycheck[] =
{
      11,    12,     2,    13,    26,    16,    25,     7,     8,     9,
      10,    26,    26,    10,    11,    29,    25,     3,     4,     3,
       4,     3,     6,     3,     6,    35,     6,    52,    36,    19,
      27,    28,    32,    33,    34,    35,    36,    32,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    33,    59,    60,
      61,     1,    63,     3,     4,     5,     6,    82,    48,     3,
       4,     5,    12,     3,     4,    59,    60,    34,    25,    19,
      20,    30,     6,    29,    28,    26,    34,    88,     0,    29,
       0,    31,    80,    33,    95,     3,     4,     5,     6,    61,
       3,     4,     5,     6,    12,    13,    -1,    -1,    -1,    12,
      -1,    19,    20,    -1,    -1,    -1,    19,    20,    -1,    -1,
      -1,    29,    -1,    31,    -1,    33,    29,    -1,    31,    -1,
      33,     7,     8,     9,    10,    11,    -1,    -1,    -1,    15,
      16,    17,    18,    19,    20,    21,    22,    -1,    -1,    -1,
      -1,    27,    28,    -1,    30,     7,     8,     9,    10,    11,
      -1,    13,    -1,    15,    16,    17,    18,    19,    20,    21,
      22,    -1,    -1,    -1,    -1,    27,    28,     7,     8,     9,
      10,    11,    -1,    13,    -1,    15,    16,    17,    18,    19,
      20,    21,    22,    -1,    -1,    -1,    -1,    27,    28,     7,
       8,     9,    10,    11,    -1,    -1,    10,    11,    16,    17,
      18,    19,    20,    21,    22,    19,    20,    21,    22,    27,
      28,    10,    11,    27,    28,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    22,    -1,    -1,    -1,    -1,    27,    28
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#ifdef YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif

#line 315 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  YYSIZE_T yystacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);
# endif
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (yyls);
# endif
# undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
#if YYLSP_NEEDED
      yylsp = yyls + yysize - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 1:
#line 439 "parser.y"
{
		unregister_allocation (yyvsp[0].expr);
		unregister_allocation (yyvsp[-1].list);
		state->result = gnm_expr_list_prepend (yyvsp[-1].list, yyvsp[0].expr);
	}
    break;
case 2:
#line 445 "parser.y"
{
		if (state->result != NULL) {
			gnm_expr_list_unref (state->result);
			state->result = NULL;
		}
	}
    break;
case 3:
#line 453 "parser.y"
{
	       unregister_allocation (yyvsp[-1].expr);
	       unregister_allocation (yyvsp[-2].list);
	       yyval.list = gnm_expr_list_prepend (yyvsp[-2].list, yyvsp[-1].expr);
	       register_expr_list_allocation (yyval.list);
	}
    break;
case 4:
#line 459 "parser.y"
{ yyval.list = NULL; register_expr_list_allocation (yyval.list); }
    break;
case 5:
#line 462 "parser.y"
{ yyval.expr = yyvsp[0].expr; }
    break;
case 6:
#line 463 "parser.y"
{ yyval.expr = yyvsp[0].expr; }
    break;
case 7:
#line 464 "parser.y"
{ yyval.expr = parse_string_as_value_or_name (yyvsp[0].expr); }
    break;
case 8:
#line 465 "parser.y"
{ yyval.expr = yyvsp[0].expr; }
    break;
case 9:
#line 466 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_ADD,	yyvsp[0].expr); }
    break;
case 10:
#line 467 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_SUB,	yyvsp[0].expr); }
    break;
case 11:
#line 468 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_MULT,	yyvsp[0].expr); }
    break;
case 12:
#line 469 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_DIV,	yyvsp[0].expr); }
    break;
case 13:
#line 470 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_EXP,	yyvsp[0].expr); }
    break;
case 14:
#line 471 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_CAT,	yyvsp[0].expr); }
    break;
case 15:
#line 472 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_EQUAL,	yyvsp[0].expr); }
    break;
case 16:
#line 473 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_LT,		yyvsp[0].expr); }
    break;
case 17:
#line 474 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_GT,		yyvsp[0].expr); }
    break;
case 18:
#line 475 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_GTE,	yyvsp[0].expr); }
    break;
case 19:
#line 476 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_NOT_EQUAL,	yyvsp[0].expr); }
    break;
case 20:
#line 477 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_LTE,	yyvsp[0].expr); }
    break;
case 21:
#line 478 "parser.y"
{ yyval.expr = build_logical (yyvsp[-2].expr, TRUE,	yyvsp[0].expr); }
    break;
case 22:
#line 479 "parser.y"
{ yyval.expr = build_logical (yyvsp[-2].expr, FALSE, yyvsp[0].expr); }
    break;
case 23:
#line 480 "parser.y"
{ yyval.expr = yyvsp[-1].expr; }
    break;
case 24:
#line 482 "parser.y"
{ yyval.expr = build_unary_op (GNM_EXPR_OP_UNARY_NEG, yyvsp[0].expr); }
    break;
case 25:
#line 483 "parser.y"
{ yyval.expr = build_unary_op (GNM_EXPR_OP_UNARY_PLUS, yyvsp[0].expr); }
    break;
case 26:
#line 484 "parser.y"
{ yyval.expr = build_not (yyvsp[0].expr); }
    break;
case 27:
#line 485 "parser.y"
{ yyval.expr = build_unary_op (GNM_EXPR_OP_PERCENTAGE, yyvsp[-1].expr); }
    break;
case 28:
#line 487 "parser.y"
{
		unregister_allocation (yyvsp[-1].list);
		yyval.expr = build_array (yyvsp[-1].list);
		free_expr_list_list (yyvsp[-1].list);
	}
    break;
case 30:
#line 494 "parser.y"
{
		GnmNamedExpr *expr_name = NULL;
		char const *name = yyvsp[0].expr->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = yyvsp[-1].sheet.first;
		if (yyvsp[-1].sheet.last != NULL)
			gnumeric_parse_error (
				state, PERR_3D_NAME,
				g_strdup_printf (_("What is a 3D name %s:%s!%s ?"),
						yyvsp[-1].sheet.first->name_quoted,
						yyvsp[-1].sheet.last->name_quoted,
						name),
				state->expr_text - state->expr_backup + 1, strlen (name));
		else {
			expr_name = expr_name_lookup (&pos, name);
			if (expr_name == NULL)
				gnumeric_parse_error (
					state, PERR_UNKNOWN_NAME,
					g_strdup_printf (_("Name '%s' does not exist in sheet '%s'"),
							name, pos.sheet->name_quoted),
					state->expr_text - state->expr_backup + 1, strlen (name));
		}

		unregister_allocation (yyvsp[0].expr); gnm_expr_unref (yyvsp[0].expr);
		if (expr_name == NULL)
			return ERROR;
	        yyval.expr = register_expr_allocation (gnm_expr_new_name (expr_name, yyvsp[-1].sheet.first, NULL));
	}
    break;
case 31:
#line 523 "parser.y"
{
		GnmNamedExpr *expr_name;
		char *name = yyvsp[0].expr->constant.value->v_str.val->str;
		char *wb_name = yyvsp[-2].expr->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = NULL;
		pos.wb = application_workbook_get_by_name (wb_name);

		if (pos.wb == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_WORKBOOK,
				g_strdup_printf (_("Unknown workbook '%s'"), wb_name), 
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].expr); gnm_expr_unref (yyvsp[0].expr);
			unregister_allocation (yyvsp[-2].expr); gnm_expr_unref (yyvsp[-2].expr);
			return retval;
		}

		expr_name = expr_name_lookup (&pos, name);
		if (expr_name == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_NAME,
				g_strdup_printf (_("Name '%s' does not exist in workbook '%s'"),
						name, wb_name),
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].expr); gnm_expr_unref (yyvsp[0].expr);
			unregister_allocation (yyvsp[-2].expr); gnm_expr_unref (yyvsp[-2].expr);
			return retval;
		} else {
			unregister_allocation (yyvsp[0].expr); gnm_expr_unref (yyvsp[0].expr);
			unregister_allocation (yyvsp[-2].expr); gnm_expr_unref (yyvsp[-2].expr);
		}
	        yyval.expr = register_expr_allocation (gnm_expr_new_name (expr_name, NULL, pos.wb));
	}
    break;
case 32:
#line 562 "parser.y"
{
		char const *name = yyvsp[-3].expr->constant.value->v_str.val->str;
		FunctionDefinition *f = func_lookup_by_name (name,
			state->pos->wb);

		/* THINK TODO: Do we want to make this workbook-local??  */
		if (f == NULL && state->create_placeholder_for_unknown_func)
			f = function_add_placeholder (name, "");

		unregister_allocation (yyvsp[-1].list);
		unregister_allocation (yyvsp[-3].expr); gnm_expr_unref (yyvsp[-3].expr);

		if (f == NULL) {
			gnm_expr_list_unref (yyvsp[-1].list);
			YYERROR;
		} else {
			yyval.expr = register_expr_allocation (gnm_expr_new_funcall (f, yyvsp[-1].list));
		}
	}
    break;
case 35:
#line 587 "parser.y"
{
		Sheet *sheet = parser_sheet_by_name (state->pos->wb, yyvsp[-1].expr);
		unregister_allocation (yyvsp[-1].expr); gnm_expr_unref (yyvsp[-1].expr);
		if (sheet == NULL)
			return ERROR;
	        yyval.sheet.first = sheet;
	        yyval.sheet.last = NULL;
	}
    break;
case 36:
#line 596 "parser.y"
{
		Workbook *wb = application_workbook_get_by_name (
			yyvsp[-3].expr->constant.value->v_str.val->str);
		Sheet *sheet = parser_sheet_by_name (wb, yyvsp[-1].expr);

		unregister_allocation (yyvsp[-3].expr); gnm_expr_unref (yyvsp[-3].expr);
		unregister_allocation (yyvsp[-1].expr); gnm_expr_unref (yyvsp[-1].expr);

		if (sheet == NULL)
			return ERROR;
	        yyval.sheet.first = sheet;
	        yyval.sheet.last = NULL;
        }
    break;
case 38:
#line 612 "parser.y"
{ yyval.sheet.first = yyval.sheet.last = NULL; }
    break;
case 39:
#line 615 "parser.y"
{
		if (state->force_explicit_sheet_references &&
		    force_explicit_sheet_references (state, &yyvsp[0].expr->cellref.ref)) {
			unregister_allocation (yyvsp[0].expr);
			gnm_expr_unref (yyvsp[0].expr);
			return ERROR;
		}
	        yyval.expr = yyvsp[0].expr;
	}
    break;
case 40:
#line 625 "parser.y"
{
		yyvsp[0].expr->cellref.ref.sheet = yyvsp[-1].sheet.first;
		if (state->use_excel_reference_conventions && yyvsp[-1].sheet.last != NULL) {
			CellRef tmp = yyvsp[0].expr->cellref.ref;
			yyval.expr = register_expr_allocation
				(gnm_expr_new_constant
				 (value_new_cellrange (&(yyvsp[0].expr->cellref.ref), &tmp,
						       state->pos->eval.col, state->pos->eval.row)));
			unregister_allocation (yyvsp[0].expr);
			gnm_expr_unref (yyvsp[0].expr);
		} else
			yyval.expr = yyvsp[0].expr;
	}
    break;
case 41:
#line 639 "parser.y"
{
		unregister_allocation (yyvsp[0].expr);
		unregister_allocation (yyvsp[-2].expr);

		if (state->force_explicit_sheet_references &&
		    (force_explicit_sheet_references (state, &yyvsp[-2].expr->cellref.ref) ||
		     force_explicit_sheet_references (state, &yyvsp[0].expr->cellref.ref))) {
			gnm_expr_unref (yyvsp[0].expr);
			gnm_expr_unref (yyvsp[-2].expr);
			return ERROR;
		}

		yyval.expr = register_expr_allocation
			(gnm_expr_new_constant
			 (value_new_cellrange (&(yyvsp[-2].expr->cellref.ref), &(yyvsp[0].expr->cellref.ref),
					       state->pos->eval.col, state->pos->eval.row)));
		gnm_expr_unref (yyvsp[0].expr);
		gnm_expr_unref (yyvsp[-2].expr);
	}
    break;
case 42:
#line 659 "parser.y"
{
		unregister_allocation (yyvsp[0].expr);
		unregister_allocation (yyvsp[-3].expr);
		yyvsp[-3].expr->cellref.ref.sheet = yyvsp[-4].sheet.first;
		if (state->use_excel_reference_conventions) {
			yyvsp[0].expr->cellref.ref.sheet = yyvsp[-4].sheet.last ? yyvsp[-4].sheet.last : yyvsp[-4].sheet.first;
		} else {
			yyvsp[0].expr->cellref.ref.sheet = yyvsp[-1].sheet.first ? yyvsp[-1].sheet.first : yyvsp[-4].sheet.first;
		}
		yyval.expr = register_expr_allocation
			(gnm_expr_new_constant
			 (value_new_cellrange (&(yyvsp[-3].expr->cellref.ref), &(yyvsp[0].expr->cellref.ref),
					       state->pos->eval.col, state->pos->eval.row)));

		gnm_expr_unref (yyvsp[0].expr);
		gnm_expr_unref (yyvsp[-3].expr);
	}
    break;
case 43:
#line 677 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_RANGE_CTOR, yyvsp[0].expr); }
    break;
case 44:
#line 678 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_RANGE_CTOR, yyvsp[0].expr); }
    break;
case 45:
#line 679 "parser.y"
{ yyval.expr = build_binop (yyvsp[-2].expr, GNM_EXPR_OP_RANGE_CTOR, yyvsp[0].expr); }
    break;
case 46:
#line 682 "parser.y"
{
		unregister_allocation (yyvsp[0].expr);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].expr);
		register_expr_list_allocation (yyval.list);
        }
    break;
case 47:
#line 687 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].expr);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].expr);
		register_expr_list_allocation (yyval.list);
	}
    break;
case 48:
#line 693 "parser.y"
{
		GSList *tmp = yyvsp[0].list;
		unregister_allocation (yyvsp[0].list);

		if (tmp == NULL)
			tmp = gnm_expr_list_prepend (NULL, gnm_expr_new_constant (value_new_empty ()));

		yyval.list = gnm_expr_list_prepend (tmp, gnm_expr_new_constant (value_new_empty ()));
		register_expr_list_allocation (yyval.list);
	}
    break;
case 49:
#line 703 "parser.y"
{ yyval.list = NULL; }
    break;
case 50:
#line 706 "parser.y"
{ yyval.expr = yyvsp[0].expr; }
    break;
case 51:
#line 707 "parser.y"
{ yyval.expr = parse_string_as_value (yyvsp[0].expr); }
    break;
case 52:
#line 710 "parser.y"
{
		unregister_allocation (yyvsp[0].expr);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].expr);
		register_expr_list_allocation (yyval.list);
        }
    break;
case 53:
#line 715 "parser.y"
{
		if (state->array_col_separator == ',') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].expr);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].expr);
			register_expr_list_allocation (yyval.list);
		} else {
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	}
    break;
case 54:
#line 728 "parser.y"
{
		if (state->array_col_separator == '\\') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].expr);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].expr);
			register_expr_list_allocation (yyval.list);
		} else {
			/* FIXME: Is this the right error to display? */
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	}
    break;
case 55:
#line 742 "parser.y"
{ yyval.list = NULL; }
    break;
case 56:
#line 745 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].list);
		register_expr_list_list_allocation (yyval.list);
        }
    break;
case 57:
#line 750 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].list);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].list);
		register_expr_list_list_allocation (yyval.list);
	}
    break;
}

#line 705 "/usr/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[YYTRANSLATE (yychar)]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[YYTRANSLATE (yychar)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}
#line 757 "parser.y"

/**
 * parse_ref_or_string :
 * @string: the string to try.
 *
 * Attempt to parse the text as a cellref, if it fails
 * return a string.
 * DO NOT attempt to do higher level lookups here.
 *     - sheet names
 *     - function names
 *     - expression names
 *     - value parsing
 * must all be handled by the parser not the lexer.
 */
static int
parse_ref_or_string (char const *string)
{
	CellRef   ref;
	Value *v = NULL;
	char const * res;

	res = cellref_get (&ref, string, &state->pos->eval);
	if (res != NULL && *res == '\0') {
		if (state->force_absolute_col_references &&
		    ref.col_relative) {
			ref.col += state->pos->eval.col;
			ref.col_relative = FALSE;
		}
		if (state->force_absolute_row_references &&
		    ref.row_relative) {
			ref.row += state->pos->eval.row;
			ref.row_relative = FALSE;
		}
		yylval.expr = register_expr_allocation (gnm_expr_new_cellref (&ref));
		return CELLREF;
	}

	v = value_new_string (string);
	yylval.expr = register_expr_allocation (gnm_expr_new_constant (v));
	return STRING;
}

/**
 * find_char:
 * @str:
 * @c:
 *
 * Returns a pointer to character c in str.
 * Callers should check whether p is '\0'!
 **/
static char const *
find_char (char const *str, char c)
{
	for (; *str && *str != c; str = g_utf8_next_char (str))
		if (*str == '\\' && str[1])
			str = g_utf8_next_char (str);
	return str;
}

static char const *
find_matching_close (char const *str, char const **res)
{
	for (; *str; str = g_utf8_next_char (str)) {
		if (*str == '(') {
			char const *tmp = str;
			str = find_matching_close (str + 1, res);
			if (*str != ')' && *res == NULL) {
				*res = tmp;
				return str;
			}
		} else if (*str == ')')
			return str;
		else if (*str == '\'' || *str == '\"')
			str = find_char (str + 1, *str);
	}

	return str;
}

int
yylex (void)
{
	gunichar c;
	char const *start;
	gboolean is_number = FALSE;

        while (g_unichar_isspace (g_utf8_get_char (state->expr_text)))
                state->expr_text = g_utf8_next_char (state->expr_text);

	start = state->expr_text;
	c = g_utf8_get_char (start);
	state->expr_text = g_utf8_next_char (state->expr_text);

	if (c == '(' || c == ')')
		return c;

	if (state->use_excel_reference_conventions) {
		if (c == ':')
			return RANGE_SEP;
		if (c == '!')
			return SHEET_SEP;
	} else {
		/* Treat '..' as range sep (A1..C3) */
		if (c == '.' && *state->expr_text == '.') {
			state->expr_text++;
			return RANGE_SEP;
		}
		if (c == ':')
			return SHEET_SEP;
		if (c == '#') {
			if (!strncmp (state->expr_text, "NOT#", 4)) {
				state->expr_text += 4;
				return NOT;
			}
			if (!strncmp (state->expr_text, "AND#", 4)) {
				state->expr_text += 4;
				return AND;
			}
			if (!strncmp (state->expr_text, "OR#", 3)) {
				state->expr_text += 3;
				return OR;
			}
		}
	}

	if (c == state->separator)
		return SEPARATOR;

	if (c == state->decimal_point) {
		/* Could be a number or a stand alone  */
		if (!g_unichar_isdigit (g_utf8_get_char (state->expr_text)))
			return c;
		is_number = TRUE;
	} else if (g_unichar_isdigit (c)) {
		do {
			c = g_utf8_get_char (state->expr_text);
			state->expr_text = g_utf8_next_char (state->expr_text);
		} while (g_unichar_isdigit (c));
		is_number = TRUE;
	}

	if (is_number) {
		Value *v = NULL;

		if (c == state->decimal_point || c == 'e' || c == 'E') {
			/* This is float */
			char *end;
			gnum_float d;

			errno = 0;
			d = strtognum (start, &end);
			if (start == end) {
				g_warning ("%s is not a double, but was expected to be one", start);
			}  else if (errno != ERANGE) {
				v = value_new_float (d);
				state->expr_text = end;
			} else if (c != 'e' && c != 'E') {
				gnumeric_parse_error (
					state, PERR_OUT_OF_RANGE,
					g_strdup (_("The number is out of range")),
					state->expr_text - state->expr_backup, end - start);
				return INVALID_TOKEN;
			} else {
				/* For an exponent it's hard to highlight the
				 * right region w/o it turning into an ugly
				 * hack, for now the cursor is put at the end.
				 */
				gnumeric_parse_error (
					state, PERR_OUT_OF_RANGE,
					g_strdup (_("The number is out of range")),
					0, 0);
				return INVALID_TOKEN;
			}
		} else {
			/* This could be a row range ref or an integer */
			char *end;
			long l;

			errno = 0;
			l = strtol (start, &end, 10);
			if (start == end) {
				g_warning ("%s is not an integer, but was expected to be one", start);
			} else if (errno != ERANGE) {
				/* Check for a Row range ref (3:4 == A3:IV4) */
				if (*end == ':' && l < SHEET_MAX_COLS) {
				    /* TODO : adjust parser to allow returning
				     * a range, not just a cellref
				     */
				}
				v = value_new_int (l);
				state->expr_text = end;
			} else if (l == LONG_MIN || l == LONG_MAX) {
				gnum_float d;

				errno = 0;
				d = strtognum (start, &end);
				if (errno != ERANGE) {
					v = value_new_float (d);
					state->expr_text = end;
				} else {
					gnumeric_parse_error (
						state, PERR_OUT_OF_RANGE,
						g_strdup (_("The number is out of range")),
						state->expr_text - state->expr_backup, end - start);
					return INVALID_TOKEN;
				}
			}
		}

		/* Very odd string,  Could be a bound problem.  Trigger an error */
		if (v == NULL)
			return c;

		yylval.expr = register_expr_allocation (gnm_expr_new_constant (v));
		return CONSTANT;
	}

	switch (c){
	case '\'':
	case '"': {
		char const *p;
		char *string, *s;
		char quotes_end = c;
		Value *v;

 		p = state->expr_text;
 		state->expr_text = find_char (state->expr_text, quotes_end);
		if (!*state->expr_text) {
  			gnumeric_parse_error (
  				state, PERR_MISSING_CLOSING_QUOTE,
				g_strdup (_("Could not find matching closing quote")),
  				(p - state->expr_backup) + 1, 1);
			return INVALID_TOKEN;
		}

		s = string = (char *) alloca (1 + state->expr_text - p);
		/* this is safe for utf8 */
		while (p != state->expr_text) {
			if (*p == '\\'){
				p++;
				*s++ = *p++;
			} else
				*s++ = *p++;
		}
		*s = 0;
		state->expr_text++;

		v = value_new_string (string);
		yylval.expr = register_expr_allocation (gnm_expr_new_constant (v));
		return QUOTED_STRING;
	}
	}

	if (g_unichar_isalpha (c) || c == '_' || c == '$'){
		char const *start = state->expr_text - 1;
		char *str;
		int  len;
		gunichar tmp;

		while ((tmp = g_utf8_get_char (state->expr_text)) != 0 &&
		       (g_unichar_isalnum (tmp) || tmp == '_' || tmp == '$' ||
		       (state->use_excel_reference_conventions && tmp == '.')))
			state->expr_text = g_utf8_next_char (state->expr_text);

		len = state->expr_text - start;
		str = alloca (len + 1);
		strncpy (str, start, len);
		str [len] = 0;
		return parse_ref_or_string (str);
	}

	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return LTE;
		}
		if (*state->expr_text == '>'){
			state->expr_text++;
			return NE;
		}
		return c;
	}

	if (c == '>'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return GTE;
		}
		return c;
	}

	return c;
}

int
yyerror (const char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

/**
 * gnm_expr_parse_str:
 *
 * @expr_text   : The string to parse.
 * @flags       : See parse-utils for descriptions
 * @error       : optionally NULL ptr to store details of error.
 *
 * Parse a string. if @error is non-null it will be assumed that the
 * caller has passed a pointer to a ParseError struct AND that it will
 * take responsibility for freeing that struct and it's contents.
 * with parse_error_free.
 **/
GnmExpr const *
gnm_expr_parse_str (char const *expr_text, ParsePos const *pos,
		    GnmExprParseFlags flags,
		    ParseError *error)
{
	GnmExpr const *expr;
	ParserState pstate;

	g_return_val_if_fail (expr_text != NULL, NULL);

	pstate.expr_text   = expr_text;
	pstate.expr_backup = expr_text;
	pstate.pos	   = pos;

	pstate.decimal_point	   = format_get_decimal ();
	pstate.separator 	   = format_get_arg_sep ();
	pstate.array_col_separator = format_get_col_sep ();

	pstate.use_excel_reference_conventions	   	= !(flags & GNM_EXPR_PARSE_USE_APPLIX_REFERENCE_CONVENTIONS);
	pstate.create_placeholder_for_unknown_func	= flags & GNM_EXPR_PARSE_CREATE_PLACEHOLDER_FOR_UNKNOWN_FUNC;
	pstate.force_absolute_col_references		= flags & GNM_EXPR_PARSE_FORCE_ABSOLUTE_COL_REFERENCES;
	pstate.force_absolute_row_references		= flags & GNM_EXPR_PARSE_FORCE_ABSOLUTE_ROW_REFERENCES;
	pstate.force_explicit_sheet_references		= flags & GNM_EXPR_PARSE_FORCE_EXPLICIT_SHEET_REFERENCES;

	pstate.result = NULL;
	pstate.error = error;
	
	if (deallocate_stack == NULL)
		deallocate_init ();

	g_return_val_if_fail (pstate.pos != NULL, NULL);
	g_return_val_if_fail (pstate.expr_text != NULL, NULL);
	g_return_val_if_fail (state == NULL, NULL);

	state = &pstate;
	yyparse ();
	state = NULL;

	if (pstate.result != NULL) {
		deallocate_assert_empty ();

#if 0
		/* If this happens, something is very wrong */
		if (pstate.error != NULL && pstate.error->message != NULL) {
			g_warning ("An error occurred and the GnmExpr is non-null! This should not happen");
			g_warning ("Error message is %s (%d, %d)", pstate.error->message, pstate.error->begin_char,
					pstate.error->end_char);
		}
#endif

		/* Do we have multiple expressions */
		if (pstate.result->next != NULL) {
			if (flags & GNM_EXPR_PARSE_PERMIT_MULTIPLE_EXPRESSIONS)
				expr = gnm_expr_new_set (g_slist_reverse (pstate.result));
			else {
				gnm_expr_list_unref (pstate.result);
				gnumeric_parse_error (&pstate, PERR_MULTIPLE_EXPRESSIONS,
					g_strdup (_("Multiple expressions are not supported in this context")),
					(pstate.expr_text - pstate.expr_backup) + 1,
					(pstate.expr_text - pstate.expr_backup));
				expr = NULL;
			}
		} else {
			/* Free the list, do not unref the content */
			expr = pstate.result->data;
			gnm_expr_list_free (pstate.result);
		}
	} else {
		/* If there is no error message, attempt to be more detailed */
		if (pstate.error != NULL && pstate.error->message == NULL) {
			char const *last_token = pstate.expr_text - 1;

			if (*last_token == '\0') {
				char const *str = pstate.expr_backup;
				char const *res = NULL;
				char const *last = find_matching_close (str, &res);

				if (*last)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_OPEN,
						g_strdup (_("Could not find matching opening parenthesis")),
						(last - str) + 2, 1);
				else if (res != NULL)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_CLOSE,
						g_strdup (_("Could not find matching closing parenthesis")),
						(res - str) + 2, 1);
				else
					gnumeric_parse_error (&pstate, PERR_INVALID_EXPRESSION,
						g_strdup (_("Invalid expression")),
						(pstate.expr_text - pstate.expr_backup) + 1,
						(pstate.expr_text - pstate.expr_backup));
			} else
				gnumeric_parse_error (&pstate, PERR_UNEXPECTED_TOKEN,
					g_strdup_printf (_("Unexpected token %c"), *last_token),
					(last_token - pstate.expr_backup) + 1, 1);
		}

		deallocate_all ();

		expr = NULL;
	}

	deallocate_uninit ();

	return expr;
}
