/* This code was generated by generate.  Do not edit. */

#include <gnumeric-config.h>
#include <gnumeric.h>
#include <goffice/app/go-plugin.h>
#include <gnm-plugin.h>
#include <func.h>
#include <gnm-i18n.h>
#include <value.h>
#include <mathfunc.h>
#include "extra.h"

GNM_PLUGIN_MODULE_HEADER;

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DNORM:probability density function of the normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("mu:mean of the distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("sigma:standard deviation of the distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the normal distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PNORM,R.QNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dnorm (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float sigma = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dnorm (x, mu, sigma, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PNORM:cumulative distribution function of the normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("mu:mean of the distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("sigma:standard deviation of the distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the normal distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNORM,R.QNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pnorm (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float sigma = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pnorm (x, mu, sigma, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QNORM:probability quantile function of the normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("mu:mean of the distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("sigma:standard deviation of the distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the normal distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNORM,R.PNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qnorm (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float sigma = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qnorm (p, mu, sigma, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dlnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DLNORM:probability density function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("logmean:mean of the underlying normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("logsd:standard deviation of the underlying normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PLNORM,R.QLNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dlnorm (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float logmean = value_get_as_float (args[1]);
	gnm_float logsd = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dlnorm (x, logmean, logsd, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_plnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PLNORM:cumulative distribution function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("logmean:mean of the underlying normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("logsd:standard deviation of the underlying normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DLNORM,R.QLNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_plnorm (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float logmean = value_get_as_float (args[1]);
	gnm_float logsd = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (plnorm (x, logmean, logsd, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qlnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QLNORM:probability quantile function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("logmean:mean of the underlying normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("logsd:standard deviation of the underlying normal distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the log-normal distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DLNORM,R.PLNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qlnorm (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float logmean = value_get_as_float (args[1]);
	gnm_float logsd = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qlnorm (x, logmean, logsd, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dgamma[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DGAMMA:probability density function of the gamma distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the gamma distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PGAMMA,R.QGAMMA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dgamma (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dgamma (x, shape, scale, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pgamma[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PGAMMA:cumulative distribution function of the gamma distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the gamma distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGAMMA,R.QGAMMA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pgamma (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pgamma (x, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qgamma[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QGAMMA:probability quantile function of the gamma distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the gamma distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGAMMA,R.PGAMMA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qgamma (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qgamma (p, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dbeta[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DBETA:probability density function of the beta distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("a:the first shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("b:the second scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the beta distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PBETA,R.QBETA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dbeta (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float a = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dbeta (x, a, b, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pbeta[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PBETA:cumulative distribution function of the beta distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("a:the first shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("b:the second scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the beta distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBETA,R.QBETA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pbeta (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float a = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pbeta (x, a, b, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qbeta[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QBETA:probability quantile function of the beta distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("a:the first shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("b:the second scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the beta distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBETA,R.PBETA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qbeta (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float a = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qbeta (p, a, b, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dt[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DT:probability density function of the Student t distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Student t distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PT,R.QT" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dt (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dt (x, n, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pt[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PT:cumulative distribution function of the Student t distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Student t distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DT,R.QT" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pt (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pt (x, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qt[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QT:probability quantile function of the Student t distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Student t distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DT,R.PT" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qt (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qt (p, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_df[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DF:probability density function of the F distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n1:the first number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("n2:the second number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the F distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PF,R.QF" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_df (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n1 = value_get_as_float (args[1]);
	gnm_float n2 = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (df (x, n1, n2, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pf[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PF:cumulative distribution function of the F distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n1:the first number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("n2:the second number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the F distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DF,R.QF" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pf (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n1 = value_get_as_float (args[1]);
	gnm_float n2 = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pf (x, n1, n2, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qf[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QF:probability quantile function of the F distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n1:the first number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("n2:the second number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the F distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DF,R.PF" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qf (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n1 = value_get_as_float (args[1]);
	gnm_float n2 = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qf (x, n1, n2, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dchisq[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DCHISQ:probability density function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PCHISQ,R.QCHISQ" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dchisq (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float df = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dchisq (x, df, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pchisq[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PCHISQ:cumulative distribution function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCHISQ,R.QCHISQ" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pchisq (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float df = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pchisq (x, df, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qchisq[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QCHISQ:probability quantile function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the chi-square distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCHISQ,R.PCHISQ" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qchisq (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float df = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qchisq (p, df, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dweibull[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DWEIBULL:probability density function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PWEIBULL,R.QWEIBULL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dweibull (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dweibull (x, shape, scale, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pweibull[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PWEIBULL:cumulative distribution function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DWEIBULL,R.QWEIBULL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pweibull (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pweibull (x, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qweibull[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QWEIBULL:probability quantile function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Weibull distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DWEIBULL,R.PWEIBULL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qweibull (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qweibull (p, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dpois[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DPOIS:probability density function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("lambda:the mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PPOIS,R.QPOIS" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dpois (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float lambda = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dpois (x, lambda, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_ppois[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PPOIS:cumulative distribution function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("lambda:the mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DPOIS,R.QPOIS" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_ppois (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float lambda = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (ppois (x, lambda, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qpois[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QPOIS:probability quantile function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("lambda:the mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Poisson distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DPOIS,R.PPOIS" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qpois (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float lambda = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qpois (p, lambda, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dexp[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DEXP:probability density function of the exponential distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the exponential distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PEXP,R.QEXP" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dexp (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dexp (x, scale, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pexp[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PEXP:cumulative distribution function of the exponential distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the exponential distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DEXP,R.QEXP" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pexp (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pexp (x, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qexp[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QEXP:probability quantile function of the exponential distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the exponential distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DEXP,R.PEXP" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qexp (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qexp (p, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DBINOM:probability density function of the binomial distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the binomial distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PBINOM,R.QBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dbinom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dbinom (x, n, psuc, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PBINOM:cumulative distribution function of the binomial distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the binomial distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBINOM,R.QBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pbinom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pbinom (x, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QBINOM:probability quantile function of the binomial distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the binomial distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBINOM,R.PBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qbinom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qbinom (x, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dnbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DNBINOM:probability density function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PNBINOM,R.QNBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dnbinom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dnbinom (x, n, psuc, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pnbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PNBINOM:cumulative distribution function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNBINOM,R.QNBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pnbinom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pnbinom (x, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qnbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QNBINOM:probability quantile function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNBINOM,R.PNBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qnbinom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qnbinom (p, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dhyper[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DHYPER:probability density function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("r:the number of red balls") },
	{ GNM_FUNC_HELP_ARG, F_("b:the number of black balls") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of balls drawn") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PHYPER,R.QHYPER" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dhyper (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float r = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gnm_float n = value_get_as_float (args[3]);
	gboolean give_log = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (dhyper (x, r, b, n, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_phyper[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PHYPER:cumulative distribution function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("r:the number of red balls") },
	{ GNM_FUNC_HELP_ARG, F_("b:the number of black balls") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of balls drawn") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DHYPER,R.QHYPER" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_phyper (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float r = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gnm_float n = value_get_as_float (args[3]);
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (phyper (x, r, b, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qhyper[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QHYPER:probability quantile function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("r:the number of red balls") },
	{ GNM_FUNC_HELP_ARG, F_("b:the number of black balls") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of balls drawn") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DHYPER,R.PHYPER" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qhyper (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float r = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gnm_float n = value_get_as_float (args[3]);
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (qhyper (p, r, b, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dgeom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DGEOM:probability density function of the geometric distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the geometric distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PGEOM,R.QGEOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dgeom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float psuc = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dgeom (x, psuc, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pgeom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PGEOM:cumulative distribution function of the geometric distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the geometric distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGEOM,R.QGEOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pgeom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float psuc = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pgeom (x, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qgeom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QGEOM:probability quantile function of the geometric distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the geometric distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGEOM,R.PGEOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qgeom (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float psuc = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qgeom (p, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_dcauchy[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DCAUCHY:probability density function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("location:the center of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead.  This is useful if the result would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PCAUCHY,R.QCAUCHY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dcauchy (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float location = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dcauchy (x, location, scale, give_log));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_pcauchy[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PCAUCHY:cumulative distribution function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation.") },
	{ GNM_FUNC_HELP_ARG, F_("location:the center of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCAUCHY,R.QCAUCHY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pcauchy (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float location = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pcauchy (x, location, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */


static GnmFuncHelp const help_r_qcauchy[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QCAUCHY:probability quantile function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability.") },
	{ GNM_FUNC_HELP_ARG, F_("location:the center of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered.") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, log of the probability is used.  This is useful if the probability would otherwise underflow to 0.  Defaults to false.") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCAUCHY,R.PCAUCHY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qcauchy (FunctionEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float location = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qcauchy (p, location, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

G_MODULE_EXPORT void
go_plugin_init (GOPlugin *plugin, GOCmdContext *cc)
{
}

G_MODULE_EXPORT void
go_plugin_shutdown (GOPlugin *plugin, GOCmdContext *cc)
{
}

/* ------------------------------------------------------------------------- */

GnmFuncDescriptor const stat_functions[] = {
	{
		"r.dnorm",
		"fff|b",
		F_("x,mu,sigma,give_log"),
		help_r_dnorm,
		gnumeric_r_dnorm, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pnorm",
		"fff|bb",
		F_("x,mu,sigma,lower_tail,log_p"),
		help_r_pnorm,
		gnumeric_r_pnorm, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qnorm",
		"fff|bb",
		F_("p,mu,sigma,lower_tail,log_p"),
		help_r_qnorm,
		gnumeric_r_qnorm, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dlnorm",
		"fff|b",
		F_("x,logmean,logsd,give_log"),
		help_r_dlnorm,
		gnumeric_r_dlnorm, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.plnorm",
		"fff|bb",
		F_("x,logmean,logsd,lower_tail,log_p"),
		help_r_plnorm,
		gnumeric_r_plnorm, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qlnorm",
		"fff|bb",
		F_("x,logmean,logsd,lower_tail,log_p"),
		help_r_qlnorm,
		gnumeric_r_qlnorm, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dgamma",
		"fff|b",
		F_("x,shape,scale,give_log"),
		help_r_dgamma,
		gnumeric_r_dgamma, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pgamma",
		"fff|bb",
		F_("x,shape,scale,lower_tail,log_p"),
		help_r_pgamma,
		gnumeric_r_pgamma, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qgamma",
		"fff|bb",
		F_("p,shape,scale,lower_tail,log_p"),
		help_r_qgamma,
		gnumeric_r_qgamma, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dbeta",
		"fff|b",
		F_("x,a,b,give_log"),
		help_r_dbeta,
		gnumeric_r_dbeta, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pbeta",
		"fff|bb",
		F_("x,a,b,lower_tail,log_p"),
		help_r_pbeta,
		gnumeric_r_pbeta, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qbeta",
		"fff|bb",
		F_("p,a,b,lower_tail,log_p"),
		help_r_qbeta,
		gnumeric_r_qbeta, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dt",
		"ff|b",
		F_("x,n,give_log"),
		help_r_dt,
		gnumeric_r_dt, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pt",
		"ff|bb",
		F_("x,n,lower_tail,log_p"),
		help_r_pt,
		gnumeric_r_pt, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qt",
		"ff|bb",
		F_("p,n,lower_tail,log_p"),
		help_r_qt,
		gnumeric_r_qt, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.df",
		"fff|b",
		F_("x,n1,n2,give_log"),
		help_r_df,
		gnumeric_r_df, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pf",
		"fff|bb",
		F_("x,n1,n2,lower_tail,log_p"),
		help_r_pf,
		gnumeric_r_pf, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qf",
		"fff|bb",
		F_("x,n1,n2,lower_tail,log_p"),
		help_r_qf,
		gnumeric_r_qf, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dchisq",
		"ff|b",
		F_("x,df,give_log"),
		help_r_dchisq,
		gnumeric_r_dchisq, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pchisq",
		"ff|bb",
		F_("x,df,lower_tail,log_p"),
		help_r_pchisq,
		gnumeric_r_pchisq, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qchisq",
		"ff|bb",
		F_("p,df,lower_tail,log_p"),
		help_r_qchisq,
		gnumeric_r_qchisq, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dweibull",
		"fff|b",
		F_("x,shape,scale,give_log"),
		help_r_dweibull,
		gnumeric_r_dweibull, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pweibull",
		"fff|bb",
		F_("x,shape,scale,lower_tail,log_p"),
		help_r_pweibull,
		gnumeric_r_pweibull, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qweibull",
		"fff|bb",
		F_("p,shape,scale,lower_tail,log_p"),
		help_r_qweibull,
		gnumeric_r_qweibull, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dpois",
		"ff|b",
		F_("x,lambda,give_log"),
		help_r_dpois,
		gnumeric_r_dpois, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.ppois",
		"ff|bb",
		F_("x,lambda,lower_tail,log_p"),
		help_r_ppois,
		gnumeric_r_ppois, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qpois",
		"ff|bb",
		F_("p,lambda,lower_tail,log_p"),
		help_r_qpois,
		gnumeric_r_qpois, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dexp",
		"ff|b",
		F_("x,scale,give_log"),
		help_r_dexp,
		gnumeric_r_dexp, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pexp",
		"ff|bb",
		F_("x,scale,lower_tail,log_p"),
		help_r_pexp,
		gnumeric_r_pexp, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qexp",
		"ff|bb",
		F_("p,scale,lower_tail,log_p"),
		help_r_qexp,
		gnumeric_r_qexp, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dbinom",
		"fff|b",
		F_("x,n,psuc,give_log"),
		help_r_dbinom,
		gnumeric_r_dbinom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pbinom",
		"fff|bb",
		F_("x,n,psuc,lower_tail,log_p"),
		help_r_pbinom,
		gnumeric_r_pbinom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qbinom",
		"fff|bb",
		F_("x,n,psuc,lower_tail,log_p"),
		help_r_qbinom,
		gnumeric_r_qbinom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dnbinom",
		"fff|b",
		F_("x,n,psuc,give_log"),
		help_r_dnbinom,
		gnumeric_r_dnbinom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pnbinom",
		"fff|bb",
		F_("x,n,psuc,lower_tail,log_p"),
		help_r_pnbinom,
		gnumeric_r_pnbinom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qnbinom",
		"fff|bb",
		F_("p,n,psuc,lower_tail,log_p"),
		help_r_qnbinom,
		gnumeric_r_qnbinom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dhyper",
		"ffff|b",
		F_("x,r,b,n,give_log"),
		help_r_dhyper,
		gnumeric_r_dhyper, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.phyper",
		"ffff|bb",
		F_("x,r,b,n,lower_tail,log_p"),
		help_r_phyper,
		gnumeric_r_phyper, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qhyper",
		"ffff|bb",
		F_("p,r,b,n,lower_tail,log_p"),
		help_r_qhyper,
		gnumeric_r_qhyper, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dgeom",
		"ff|b",
		F_("x,psuc,give_log"),
		help_r_dgeom,
		gnumeric_r_dgeom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pgeom",
		"ff|bb",
		F_("x,psuc,lower_tail,log_p"),
		help_r_pgeom,
		gnumeric_r_pgeom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qgeom",
		"ff|bb",
		F_("p,psuc,lower_tail,log_p"),
		help_r_qgeom,
		gnumeric_r_qgeom, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dcauchy",
		"fff|b",
		F_("x,location,scale,give_log"),
		help_r_dcauchy,
		gnumeric_r_dcauchy, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pcauchy",
		"fff|bb",
		F_("x,location,scale,lower_tail,log_p"),
		help_r_pcauchy,
		gnumeric_r_pcauchy, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qcauchy",
		"fff|bb",
		F_("p,location,scale,lower_tail,log_p"),
		help_r_qcauchy,
		gnumeric_r_qcauchy, NULL, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{ NULL }
};
