package org.gnu.libebook;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.libedataserver.EDSMemStruct;

public class EVCardAttribute extends EDSMemStruct
{
    private boolean _shouldFinalize;

    public EVCardAttribute(Handle handle, boolean shouldFinalize)
    {
        super(handle);
        _shouldFinalize = shouldFinalize;
    }

    public static EVCardAttribute getEVCardattribute(Handle handle)
    {
        return getEVCardattribute(handle, true);
    }

    public static EVCardAttribute getEVCardattribute(Handle handle, boolean shouldFinalize)
    {
        if (handle == null)
            return null;

        EVCardAttribute obj = (EVCardAttribute) MemStruct.getMemStructFromHandle(handle);
        return obj == null ? new EVCardAttribute(handle, shouldFinalize) : obj;
    }

    public EVCardAttribute copy()
    {
        return getEVCardattribute(e_vcard_attribute_copy(getHandle()));
    }

    public void addValue(String value)
    {
        e_vcard_attribute_add_value(getHandle(), value);
    }

    public void addValueDecoded(byte[] value)
    {
        e_vcard_attribute_add_value_decoded(getHandle(), value, value.length);
    }

    public void removeParams()
    {
        e_vcard_attribute_remove_params(getHandle());
    }

    public void removeValues()
    {
        e_vcard_attribute_remove_values(getHandle());
    }

    public void addParam(EVCardAttributeParam param)
    {
        e_vcard_attribute_add_param(getHandle(), param.getHandle());
    }

    public void addParamWithValue(EVCardAttributeParam param, String value)
    {
        e_vcard_attribute_add_param_with_value(getHandle(), param.getHandle(), value);
    }

    public String getGroup()
    {
        return e_vcard_attribute_get_group(getHandle());
    }

    public String getName()
    {
        return e_vcard_attribute_get_name(getHandle());
    }

    public String[] getValues()
    {
        return e_vcard_attribute_get_values(getHandle());
    }

    public byte[][] getValuesDecoded()
    {
        return e_vcard_attribute_get_values_decoded(getHandle());
    }

    public EVCardAttributeParam[] getParams()
    {
        Handle[] handles = e_vcard_attribute_get_params(getHandle());
        EVCardAttributeParam[] params = new EVCardAttributeParam[handles.length];
        for (int i = 0; i < params.length; i++)
            params[i] = EVCardAttributeParam.getEVCardattributeParam(handles[i], false);
        return params;
    }

    public static EVCardAttribute createNew(String group, String name)
    {
        return name == null ? null : getEVCardattribute(e_vcard_attribute_new(group, name));
    }

    public static EVCardAttribute createNew(String name)
    {
        return createNew(null, name);
    }

    protected void finalize() throws Throwable
    {
        if (_shouldFinalize)
            super.finalize();
    }

    native static Handle e_vcard_attribute_new(String group, String name);

    native static Handle e_vcard_attribute_copy(Handle handle);

    native static void e_vcard_attribute_add_value(Handle handle, String value);

    native static void e_vcard_attribute_add_value_decoded(Handle handle, byte[] value, int len);

    native static void e_vcard_attribute_remove_values(Handle handle);

    native static void e_vcard_attribute_remove_params(Handle handle);

    native static void e_vcard_attribute_add_param(Handle handle, Handle param);

    native static void e_vcard_attribute_add_param_with_value(Handle handle, Handle param, String value);

    native static String e_vcard_attribute_get_group(Handle handle);

    native static String e_vcard_attribute_get_name(Handle handle);

    native static String[] e_vcard_attribute_get_values(Handle handle);

    native static byte[][] e_vcard_attribute_get_values_decoded(Handle handle);

    native static Handle[] e_vcard_attribute_get_params(Handle handle);
}
