package org.gnu.libedataserver;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 * This object sits in between every EDS object extending GObject. For now, for the purpose of instantiating g_type_init
 * along with for abstractions sake.
 */
public abstract class EDSObject extends GObject
{
    protected static boolean isGTypeInitialized = false;

    static {
        System.loadLibrary("edsjni-" + Config.LIBEBOOK_API_VERSION);
        if (!isGTypeInitialized)
            g_type_init();
    }

    public EDSObject(Handle handle)
    {
        super(handle);
    }

    protected native static void g_type_init();
}