/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:27:58 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
/**
 *
 */
public class PixmapEntry extends FileEntry {
	/**
	 * Create a new Pixmap Entry.
	 */
	public PixmapEntry(String historyID, String browseDialogTitle, boolean doPreview) {
		setHandle(gnome_pixmap_entry_new(historyID, browseDialogTitle, doPreview));
		initializeEventHandlers();
	}

	/**
	 * Construct a new PixmapEntry from a handle to a native resource.
	 */
	public PixmapEntry(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
	}

	/**
	 * Set the directory for the lookup
	 */
	public void setDirectory(String directory) {
		gnome_pixmap_entry_set_pixmap_subdir(getHandle(), directory);
	}

	/**
	 * Retrun a file if it is possible to load it with gdk-pixbuf.
	 */
	public String getFilename() {
		return gnome_pixmap_entry_get_filename(getHandle());
	}
	
	/**
	 * Set if a preview should be displayed.
	 */
	public void setPreview(boolean doPreview) {
		gnome_pixmap_entry_set_preview(getHandle(), doPreview);
	}
	
	/**
	 * Set the size of the preview.
	 */
	public void setPreviewSize(int width, int height) {
		gnome_pixmap_entry_set_preview_size(getHandle(), width, height);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_pixmap_entry_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_pixmap_entry_get_type();
	native static final protected int gnome_pixmap_entry_new(String historyId, String browseDialogTitle, boolean doPreview);
	native static final protected void gnome_pixmap_entry_set_pixmap_subdir(int pentry, String subdir);
	native static final protected int gnome_pixmap_entry_scrolled_window(int pentry);
	native static final protected int gnome_pixmap_entry_preview_widget(int pentry);
	native static final protected void gnome_pixmap_entry_set_preview(int pentry, boolean doPreview);
	native static final protected void gnome_pixmap_entry_set_preview_size(int pentry, int width, int height);
	native static final protected String gnome_pixmap_entry_get_filename(int pentry);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
