/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
  * This event is used to identify when a ComboBox receives an event
 * 
 * @see ComboBoxListener
*/
public class ComboBoxEvent extends GtkEvent {

	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}

		/**
		 * This event indicates that the ComboBox selection has changed.
		 */
		public static final Type CHANGED = new Type(1, "CHANGED");

	}

	/**
	 * Constructor for ComboBoxEvent.
	 * @param source
	 * @param type
	 */
	public ComboBoxEvent(Object source, GtkEventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DialogEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
