/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.javagnome.Handle;


/**
 * The AttrShape structure is used to represent attributes which
 * impose shape restrictions.
 */
public class AttrShape extends Attribute 
{
    /**
     * Returns the ink rectangle to restrict to.
     */
    public Rectangle getInkRect(){
        return Rectangle.getRectangleFromHandle( getInkRect(getHandle()) );
    }

    /**
     * Returns the logical rectangle to restrict to.
     */
    public Rectangle getLogicalRect(){
        return Rectangle.getRectangleFromHandle( getLogicalRect(getHandle()) );
    }

    native static final protected Handle getInkRect (Handle obj);
    native static final protected Handle getLogicalRect (Handle obj);
}

