/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.glib.Handle;
import org.gnu.glib.Boxed;

/**
 * The PangoAttrColor structure is used to represent attributes that
 * are colors.
 */
public class AttrColor extends Attribute 
{
    /**
     * Returns the color.
     */
    public Color getColor(){
        Handle hndl = getColor(getHandle());
        if ( hndl != null ) {
            Boxed box = Boxed.getBoxedFromHandle( hndl );
            if ( box != null ) {
                return (Color)box;
            } else {
                return new Color( hndl );
            }
        }
        return null;
    }

    native static final protected Handle getColor(Handle handle);
}

