/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event represeting action by a {@link org.gnu.gtk.CellRendererText} widget.
 * 
 * @see CellRendererTextListener
 * @see org.gnu.gtk.CellRendererText
 */
public class CellRendererTextEvent extends GtkEvent {

    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        /**
         * This event indicates that the menu item has been activated.
         */
        public static final Type EDITED = new Type(1, "EDITED");
    }

    protected String index, text;

    /**
     * Creates a new event. This is used internally by java-gnome. Users only
     * have to deal with listeners.
     */
    public CellRendererTextEvent(Object source, String index, String text) {
        super(source, Type.EDITED);
        this.index = index;
        this.text = text;
    }

    /**
     * Returns the TreeIter index of which the text has been changed.
     * 
     * @return the TreeIter index
     */
    public String getIndex() {
        return this.index;
    }

    /**
     * Returns the new user entered text.
     * 
     * @return the user entered text
     */
    public String getText() {
        return this.text;
    }
}
