/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.Collection;

public class FString
extends SimpleVector
implements Comparable,
Appendable,
CharSeq,
Externalizable,
Consumable {
    public char[] data;
    protected static char[] empty = new char[0];

    public FString() {
        this.data = empty;
    }

    public FString(int n) {
        this.size = n;
        this.data = new char[n];
    }

    public FString(int n, char c) {
        char[] cArray = new char[n];
        this.data = cArray;
        this.size = n;
        while (--n >= 0) {
            cArray[n] = c;
        }
    }

    public FString(char[] cArray) {
        this.size = cArray.length;
        this.data = cArray;
    }

    public FString(String string) {
        this.data = string.toCharArray();
        this.size = this.data.length;
    }

    public FString(StringBuffer stringBuffer) {
        this(stringBuffer, 0, stringBuffer.length());
    }

    public FString(StringBuffer stringBuffer, int n, int n2) {
        this.size = n2;
        this.data = new char[n2];
        if (n2 > 0) {
            stringBuffer.getChars(n, n + n2, this.data, 0);
        }
    }

    public FString(char[] cArray, int n, int n2) {
        this.size = n2;
        this.data = new char[n2];
        System.arraycopy(cArray, n, this.data, 0, n2);
    }

    public FString(Sequence sequence) {
        this.data = new char[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public FString(CharSeq charSeq) {
        this(charSeq, 0, charSeq.size());
    }

    public FString(CharSeq charSeq, int n, int n2) {
        char[] cArray = new char[n2];
        charSeq.getChars(n, n + n2, cArray, 0);
        this.data = cArray;
        this.size = n2;
    }

    public FString(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public FString(CharSequence charSequence, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            cArray[n3] = charSequence.charAt(n + n3);
        }
        this.data = cArray;
        this.size = n2;
    }

    public int length() {
        return this.size;
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            char[] cArray = new char[n];
            System.arraycopy(this.data, 0, cArray, 0, n2 < n ? n2 : n);
            this.data = cArray;
        }
    }

    public void ensureBufferLength(int n) {
        if (n > this.data.length) {
            char[] cArray = new char[n < 60 ? 120 : 2 * n];
            System.arraycopy(this.data, 0, cArray, 0, n);
            this.data = cArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public final Object setBuffer(int n, Object object2) {
        Object object3 = Convert.toObject(this.data[n]);
        this.data[n] = Convert.toChar(object2);
        return object3;
    }

    public final Object get(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final char charAt(int n) {
        if (n >= this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public final char charAtBuffer(int n) {
        return this.data[n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 + n2 - n > cArray.length) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n < n2) {
            System.arraycopy(this.data, n, cArray, n3, n2 - n);
        }
    }

    public void getChars(int n, int n2, StringBuffer stringBuffer) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            stringBuffer.append(this.data, n, n2 - n);
        }
    }

    public void getChars(StringBuffer stringBuffer) {
        stringBuffer.append(this.data, 0, this.size);
    }

    public char[] toCharArray() {
        int n = this.size;
        int n2 = this.data.length;
        if (n == n2) {
            return this.data;
        }
        char[] cArray = new char[n];
        System.arraycopy(this.data, 0, cArray, 0, n);
        return cArray;
    }

    public void shift(int n, int n2, int n3) {
        System.arraycopy(this.data, n, this.data, n2, n3);
    }

    public FString copy(int n, int n2) {
        char[] cArray = new char[n2 - n];
        char[] cArray2 = this.data;
        for (int i = n; i < n2; ++i) {
            cArray[i - n] = cArray2[i];
        }
        return new FString(cArray);
    }

    public boolean addAll(FString fString) {
        int n = this.size + fString.size;
        if (this.data.length < n) {
            this.setBufferLength(n);
        }
        System.arraycopy(fString.data, 0, this.data, this.size, fString.size);
        this.size = n;
        return fString.size > 0;
    }

    public boolean addAll(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = this.size + n;
        if (this.data.length < n2) {
            this.setBufferLength(n2);
        }
        if (charSequence instanceof FString) {
            System.arraycopy(((FString)charSequence).data, 0, this.data, this.size, n);
        } else if (charSequence instanceof String) {
            ((String)charSequence).getChars(0, n, this.data, this.size);
        } else if (charSequence instanceof CharSeq) {
            ((CharSeq)charSequence).getChars(0, n, this.data, this.size);
        } else {
            int n3 = n;
            while (--n3 >= 0) {
                this.data[this.size + n3] = charSequence.charAt(n3);
            }
        }
        this.size = n2;
        return n > 0;
    }

    public void addAllStrings(Object[] objectArray, int n) {
        Object object2;
        int n2;
        int n3 = this.size;
        for (n2 = n; n2 < objectArray.length; ++n2) {
            object2 = objectArray[n2];
            n3 += ((CharSequence)object2).length();
        }
        if (this.data.length < n3) {
            this.setBufferLength(n3);
        }
        for (n2 = n; n2 < objectArray.length; ++n2) {
            object2 = objectArray[n2];
            this.addAll((CharSequence)object2);
        }
    }

    public String toString() {
        return new String(this.data, 0, this.size);
    }

    public String substring(int n, int n2) {
        return new String(this.data, n, n2 - n);
    }

    public CharSequence subSequence(int n, int n2) {
        return new FString(this.data, n, n2 - n);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.data[n] = c;
    }

    public void setCharAtBuffer(int n, char c) {
        this.data[n] = c;
    }

    public final void fill(char c) {
        char[] cArray = this.data;
        int n = this.size;
        while (--n >= 0) {
            cArray[n] = c;
        }
    }

    public void fill(int n, int n2, char c) {
        if (n < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = this.data;
        for (int i = n; i < n2; ++i) {
            cArray[i] = c;
        }
    }

    protected void clearBuffer(int n, int n2) {
        char[] cArray = this.data;
        while (--n2 >= 0) {
            cArray[n++] = '\u0000';
        }
    }

    public void replace(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(cArray, n2, this.data, n, n3);
    }

    public void replace(int n, String string) {
        string.getChars(0, string.length(), this.data, n);
    }

    public int hashCode() {
        char[] cArray = this.data;
        int n = this.size;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + cArray[i];
        }
        return n2;
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof FString)) {
            return false;
        }
        char[] cArray = ((FString)object2).data;
        int n = this.size;
        if (cArray == null || cArray.length != n) {
            return false;
        }
        char[] cArray2 = this.data;
        int n2 = n;
        while (--n2 >= 0) {
            if (cArray2[n2] == cArray[n2]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object2) {
        FString fString = (FString)object2;
        char[] cArray = this.data;
        char[] cArray2 = fString.data;
        int n = this.size;
        int n2 = fString.size;
        int n3 = n > n2 ? n2 : n;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[i];
            char c2 = cArray2[i];
            int n4 = c - c2;
            if (n4 == 0) continue;
            return n4;
        }
        return n - n2;
    }

    public int getElementKind() {
        return 29;
    }

    public void consume(Consumer consumer) {
        consumer.write(this.data, 0, this.data.length);
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.write(this.data[n2]);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n4 > this.size) {
            n4 = this.size;
        }
        if (n4 > n3) {
            consumer.write(this.data, n3, n4 - n3);
        }
    }

    public FString append(char c) {
        int n = this.size;
        if (n >= this.data.length) {
            this.ensureBufferLength(n + 1);
        }
        char[] cArray = this.data;
        cArray[n] = c;
        this.size = n + 1;
        return this;
    }

    public FString append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public FString append(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4;
        if (charSequence == null) {
            charSequence = "null";
        }
        if ((n4 = this.size) + (n3 = n2 - n) > this.data.length) {
            this.ensureBufferLength(n4 + n3);
        }
        char[] cArray = this.data;
        if (charSequence instanceof String) {
            ((String)charSequence).getChars(n, n2, cArray, n4);
        } else if (charSequence instanceof CharSeq) {
            ((CharSeq)charSequence).getChars(n, n2, cArray, n4);
        } else {
            int n5 = n4;
            for (int i = n; i < n2; ++i) {
                cArray[n5++] = charSequence.charAt(i);
            }
        }
        this.size = n4;
        return this;
    }

    public void writeTo(int n, int n2, Appendable appendable) throws IOException {
        if (appendable instanceof Writer) {
            try {
                ((Writer)appendable).write(this.data, n, n2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            appendable.append(this, n, n + n2);
        }
    }

    public void writeTo(Appendable appendable) throws IOException {
        this.writeTo(0, this.size, appendable);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        char[] cArray = this.data;
        for (int i = 0; i < n; ++i) {
            objectOutput.writeChar(cArray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = objectInput.readChar();
        }
        this.data = cArray;
        this.size = n;
    }
}

