/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.ClassType;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.xml.Document;
import gnu.kawa.xml.KDocument;
import gnu.kawa.xml.KElement;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.Nodes;
import gnu.kawa.xml.SortedNodes;
import gnu.kawa.xml.UntypedAtomic;
import gnu.lists.Consumer;
import gnu.lists.PositionConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.text.Path;
import gnu.xml.NamespaceBinding;
import gnu.xml.NodeTree;
import gnu.xml.TextUtils;
import gnu.xml.XName;
import gnu.xquery.lang.XQuery;
import gnu.xquery.util.QNameUtils;
import gnu.xquery.util.StringUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Stack;

public class NodeUtils {
    static String collectionNamespace = "http://gnu.org/kawa/cached-collections";
    public static final Symbol collectionResolverSymbol = Symbol.make("http://www.w3.org/2005/xquery-local-functions", "collection-resolver", "qexo");

    public static Object nodeName(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        if (!(object2 instanceof KNode)) {
            throw new WrongType("node-name", 1, object2, "node()?");
        }
        Symbol symbol = ((KNode)object2).getNodeSymbol();
        if (symbol == null) {
            return Values.empty;
        }
        return symbol;
    }

    public static String name(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return "";
        }
        Object object3 = ((KNode)object2).getNodeNameObject();
        if (object3 == null || object3 == Values.empty) {
            return "";
        }
        return object3.toString();
    }

    public static String localName(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return "";
        }
        if (!(object2 instanceof KNode)) {
            throw new WrongType("local-name", 1, object2, "node()?");
        }
        Object object3 = ((KNode)object2).getNodeNameObject();
        if (object3 == null || object3 == Values.empty) {
            return "";
        }
        if (object3 instanceof Symbol) {
            return ((Symbol)object3).getName();
        }
        return object3.toString();
    }

    public static Object namespaceURI(Object object2) {
        if (object2 != Values.empty && object2 != null) {
            if (!(object2 instanceof KNode)) {
                throw new WrongType("namespace-uri", 1, object2, "node()?");
            }
            Object object3 = ((KNode)object2).getNodeNameObject();
            if (object3 instanceof Symbol) {
                return QNameUtils.namespaceURIFromQName(object3);
            }
        }
        return "";
    }

    public static void prefixesFromNodetype(XName xName, Consumer consumer) {
        NamespaceBinding namespaceBinding;
        block0: for (NamespaceBinding namespaceBinding2 = namespaceBinding = xName.getNamespaceNodes(); namespaceBinding2 != null; namespaceBinding2 = namespaceBinding2.getNext()) {
            String string = namespaceBinding2.getUri();
            if (string == null) continue;
            String string2 = namespaceBinding2.getPrefix();
            NamespaceBinding namespaceBinding3 = namespaceBinding;
            while (true) {
                if (namespaceBinding3 == namespaceBinding2) {
                    consumer.writeObject(string2 == null ? "" : string2);
                    continue block0;
                }
                if (namespaceBinding3.getPrefix() == string2) continue block0;
                namespaceBinding3 = namespaceBinding3.getNext();
            }
        }
    }

    public static void inScopePrefixes$X(Object object2, CallContext callContext) {
        KElement kElement = (KElement)object2;
        Object object3 = kElement.getNodeNameObject();
        if (object3 instanceof XName) {
            NodeUtils.prefixesFromNodetype((XName)object3, callContext.consumer);
        } else {
            callContext.consumer.writeObject("xml");
        }
    }

    public static void data$X(Object object2, CallContext callContext) {
        Consumer consumer = callContext.consumer;
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.startPos();
            while ((n = values.nextPos(n)) != 0) {
                consumer.writeObject(KNode.atomicValue(values.getPosPrevious(n)));
            }
        } else {
            consumer.writeObject(KNode.atomicValue(object2));
        }
    }

    public static Object root(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        if (!(object2 instanceof KNode)) {
            throw new WrongType("root", 1, object2, "node()?");
        }
        KNode kNode = (KNode)object2;
        return Nodes.root((NodeTree)kNode.sequence, kNode.getPos());
    }

    public static KDocument rootDocument(Object object2) {
        if (!(object2 instanceof KNode)) {
            throw new WrongType("root-document", 1, object2, "node()?");
        }
        KNode kNode = (KNode)object2;
        if (!((kNode = Nodes.root((NodeTree)kNode.sequence, kNode.getPos())) instanceof KDocument)) {
            throw new WrongType("root-document", 1, object2, "document()");
        }
        return (KDocument)kNode;
    }

    public static String getLang(KNode kNode) {
        NodeTree nodeTree = (NodeTree)kNode.sequence;
        int n = nodeTree.ancestorAttribute(kNode.ipos, "http://www.w3.org/XML/1998/namespace", "lang");
        if (n == 0) {
            return null;
        }
        return KNode.getNodeValue(nodeTree, n);
    }

    public static boolean lang(Object object2, Object object3) {
        int n;
        String string = object2 == null || object2 == Values.empty ? "" : TextUtils.stringValue(object2);
        String string2 = NodeUtils.getLang((KNode)object3);
        if (string2 == null) {
            return false;
        }
        int n2 = string2.length();
        if (n2 > (n = string.length()) && string2.charAt(n) == '-') {
            string2 = string2.substring(0, n);
        }
        return string2.equalsIgnoreCase(string);
    }

    public static Object documentUri(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        if (!(object2 instanceof KNode)) {
            throw new WrongType("xs:document-uri", 1, object2, "node()?");
        }
        KNode kNode = (KNode)object2;
        Object object3 = ((NodeTree)kNode.sequence).documentUriOfPos(kNode.ipos);
        return object3 == null ? Values.empty : object3;
    }

    public static Object nilled(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        if (!(object2 instanceof KNode)) {
            throw new WrongType("nilled", 1, object2, "node()?");
        }
        if (!(object2 instanceof KElement)) {
            return Values.empty;
        }
        return Boolean.FALSE;
    }

    public static Object baseUri(Object object2) {
        if (object2 == null || object2 == Values.empty) {
            return object2;
        }
        if (!(object2 instanceof KNode)) {
            throw new WrongType("base-uri", 1, object2, "node()?");
        }
        Path path = ((KNode)object2).baseURI();
        if (path == null) {
            return Values.empty;
        }
        return path;
    }

    static Object getIDs(Object object2, Object stack) {
        if (object2 instanceof KNode) {
            object2 = KNode.atomicValue(object2);
        }
        if (object2 instanceof Values) {
            Object[] objectArray = ((Values)object2).getValues();
            int n = objectArray.length;
            while (--n >= 0) {
                stack = NodeUtils.getIDs(objectArray[n], stack);
            }
        } else {
            String string = StringUtils.coerceToString(object2, "fn:id", 1, "");
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c;
                if (Character.isWhitespace(c = string.charAt(n2++))) continue;
                int n4 = n3 = XName.isNameStart(c) ? n2 - 1 : n;
                while (n2 < n && !Character.isWhitespace(c = string.charAt(n2))) {
                    ++n2;
                    if (n3 >= n || XName.isNamePart(c)) continue;
                    n3 = n;
                }
                if (n3 < n) {
                    String string2 = string.substring(n3, n2);
                    if (stack == null) {
                        stack = string2;
                    } else {
                        Stack<Object> stack2;
                        if (stack instanceof Stack) {
                            stack2 = stack;
                        } else {
                            stack2 = new Stack<Object>();
                            stack2.push(stack);
                            stack = stack2;
                        }
                        stack2.push(string2);
                    }
                }
                ++n2;
            }
        }
        return stack;
    }

    public static void id$X(Object object2, Object object3, CallContext callContext) {
        KNode kNode = (KNode)object3;
        NodeTree nodeTree = (NodeTree)kNode.sequence;
        KDocument kDocument = (KDocument)Nodes.root(nodeTree, kNode.ipos);
        Consumer consumer = callContext.consumer;
        Object object4 = NodeUtils.getIDs(object2, null);
        if (object4 == null) {
            return;
        }
        nodeTree.makeIDtableIfNeeded();
        if (consumer instanceof PositionConsumer && (object4 instanceof String || consumer instanceof SortedNodes)) {
            NodeUtils.idScan(object4, nodeTree, (PositionConsumer)((Object)consumer));
        } else if (object4 instanceof String) {
            int n = nodeTree.lookupID((String)object4);
            if (n != -1) {
                consumer.writeObject(KNode.make(nodeTree, n));
            }
        } else {
            SortedNodes sortedNodes = new SortedNodes();
            NodeUtils.idScan(object4, nodeTree, sortedNodes);
            Values.writeValues(sortedNodes, consumer);
        }
    }

    private static void idScan(Object object2, NodeTree nodeTree, PositionConsumer positionConsumer) {
        if (object2 instanceof String) {
            int n = nodeTree.lookupID((String)object2);
            if (n != -1) {
                positionConsumer.writePosition(nodeTree, n);
            }
        } else if (object2 instanceof Stack) {
            Stack stack = (Stack)object2;
            int n = stack.size();
            for (int i = 0; i < n; ++i) {
                NodeUtils.idScan(stack.elementAt(i), nodeTree, positionConsumer);
            }
        }
    }

    public static Object idref(Object object2, Object object3) {
        KNode kNode = (KNode)object3;
        KDocument kDocument = (KDocument)Nodes.root((NodeTree)kNode.sequence, kNode.getPos());
        return Values.empty;
    }

    public static void setSavedCollection(Object object2, Object object3, Environment environment) {
        if (object2 == null) {
            object2 = "#default";
        }
        Symbol symbol = Symbol.make(collectionNamespace, object2.toString());
        environment.put(symbol, null, object3);
    }

    public static void setSavedCollection(Object object2, Object object3) {
        NodeUtils.setSavedCollection(object2, object3, Environment.getCurrent());
    }

    public static Object getSavedCollection(Object object2, Environment environment) {
        Symbol symbol;
        Object object3;
        if (object2 == null) {
            object2 = "#default";
        }
        if ((object3 = environment.get(symbol = Symbol.make(collectionNamespace, object2.toString()), null, null)) == null) {
            throw new RuntimeException("collection '" + object2 + "' not found");
        }
        return object3;
    }

    public static Object getSavedCollection(Object object2) {
        return NodeUtils.getSavedCollection(object2, Environment.getCurrent());
    }

    public static Object collection(Object object2, Object object3) throws Throwable {
        String string;
        int n;
        Symbol symbol;
        object2 = NodeUtils.resolve(object2, object3, "collection");
        Environment environment = Environment.getCurrent();
        Object object4 = environment.get(symbol = collectionResolverSymbol, null, null);
        if (object4 == null) {
            object4 = environment.get(Symbol.makeWithUnknownNamespace(symbol.getLocalName(), symbol.getPrefix()), null, null);
        }
        if (object4 == null) {
            return NodeUtils.getSavedCollection(object2);
        }
        if ((object4 instanceof String || object4 instanceof UntypedAtomic) && (n = (string = object4.toString()).indexOf(58)) > 0) {
            Class<?> clazz;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("invalid collection-resolver: class " + string2 + " not found");
            }
            catch (Throwable throwable) {
                throw new RuntimeException("invalid collection-resolver: " + throwable);
            }
            ClassType classType = (ClassType)ClassType.make(clazz);
            object4 = ClassMethods.apply(classType, string3, '\u0000', XQuery.instance);
            if (object4 == null) {
                throw new RuntimeException("invalid collection-resolver: no method " + string3 + " in " + string2);
            }
        }
        if (!(object4 instanceof Procedure)) {
            throw new RuntimeException("invalid collection-resolver: " + object4);
        }
        return ((Procedure)object4).apply1(object2);
    }

    static Object resolve(Object object2, Object object3, String string) throws Throwable {
        if (!(object2 instanceof File || object2 instanceof Path || object2 instanceof URI || object2 instanceof URL)) {
            object2 = StringUtils.coerceToString(object2, string, 1, null);
        }
        if (object2 == Values.empty || object2 == null) {
            return null;
        }
        return Path.currentPath().resolve(Path.valueOf(object2));
    }

    public static Object docCached(Object object2, Object object3) throws Throwable {
        if ((object2 = NodeUtils.resolve(object2, object3, "doc")) == null) {
            return Values.empty;
        }
        return Document.parseCached(object2);
    }

    public static boolean availableCached(Object object2, Object object3) throws Throwable {
        if ((object2 = NodeUtils.resolve(object2, object3, "doc-available")) == null) {
            return false;
        }
        try {
            Document.parseCached(object2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

