/*-
 * Copyright 2016 Netflix, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#include <efi.h>
#include <efilib.h>

/*
 * CHAR16 related functions moved from loader.
 * Perhaps we should move those to libsa afterall, but they are
 * needed only by UEFI.
 */

int
wcscmp(CHAR16 *a, CHAR16 *b)
{

	while (*a && *b && *a == *b) {
		a++;
		b++;
	}
	return *a - *b;
}

/*
 * cpy8to16 copies a traditional C string into a CHAR16 string and
 * 0 terminates it. len is the size of *dst in bytes.
 */
void
cpy8to16(const char *src, CHAR16 *dst, size_t len)
{
	len <<= 1;		/* Assume CHAR16 is 2 bytes */
	while (len > 0 && *src) {
		*dst++ = *src++;
		len--;
	}
	*dst++ = (CHAR16)0;
}

void
cpy16to8(const CHAR16 *src, char *dst, size_t len)
{
	size_t i;

	for (i = 0; i < len && src[i]; i++)
		dst[i] = (char)src[i];
	if (i < len)
		dst[i] = '\0';
}
