/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws2.polly;

import org.apache.camel.component.aws2.polly.client.Polly2ClientFactory;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.polly.PollyClient;

import static org.junit.jupiter.api.Assertions.assertNotNull;

public class Polly2ClientFactoryTest {

    @Test
    public void getClientWithAccessKeyAndSecretKey() {
        Polly2Configuration configuration = new Polly2Configuration();
        configuration.setAccessKey("accessKey");
        configuration.setSecretKey("secretKey");
        configuration.setRegion("us-east-1");

        PollyClient client = Polly2ClientFactory.getPollyClient(configuration);
        assertNotNull(client);
        client.close();
    }

    @Test
    public void getClientWithDefaultCredentialsProvider() {
        Polly2Configuration configuration = new Polly2Configuration();
        configuration.setUseDefaultCredentialsProvider(true);
        configuration.setRegion("us-east-1");

        // Just verify the client is created - actual credential resolution happens on first API call
        PollyClient client = Polly2ClientFactory.getPollyClient(configuration);
        assertNotNull(client);
        client.close();
    }
}
