/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public class RecordComponentInfo
implements Node {
    private final int index;
    private final int descriptorIndex;
    private final Attribute[] attributes;
    private final ConstantPool constantPool;

    public RecordComponentInfo(DataInput input, ConstantPool constantPool) throws IOException {
        this.index = input.readUnsignedShort();
        this.descriptorIndex = input.readUnsignedShort();
        int attributesCount = input.readUnsignedShort();
        this.attributes = new Attribute[attributesCount];
        for (int j = 0; j < attributesCount; ++j) {
            this.attributes[j] = Attribute.readAttribute(input, constantPool);
        }
        this.constantPool = constantPool;
    }

    @Override
    public void accept(Visitor v) {
        v.visitRecordComponent(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.index);
        file.writeShort(this.descriptorIndex);
        file.writeShort(this.attributes.length);
        for (Attribute attribute : this.attributes) {
            attribute.dump(file);
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("RecordComponentInfo(");
        buf.append(this.constantPool.getConstantString(this.index, (byte)1));
        buf.append(",");
        buf.append(this.constantPool.getConstantString(this.descriptorIndex, (byte)1));
        buf.append(",");
        buf.append(this.attributes.length);
        buf.append("):\n");
        for (Attribute attribute : this.attributes) {
            buf.append("  ").append(attribute.toString()).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

