/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.io.File;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCombinerTest {
    static File CONF1 = ConfigurationAssert.getTestFile("testcombine1.xml");
    static File CONF2 = ConfigurationAssert.getTestFile("testcombine2.xml");
    protected NodeCombiner combiner;

    @Before
    public void setUp() throws Exception {
        this.combiner = this.createCombiner();
    }

    protected abstract NodeCombiner createCombiner();

    protected HierarchicalConfiguration createCombinedConfiguration() throws ConfigurationException {
        XMLConfiguration conf1 = new XMLConfiguration(CONF1);
        XMLConfiguration conf2 = new XMLConfiguration(CONF2);
        ConfigurationNode cn = this.combiner.combine(conf1.getRootNode(), conf2.getRootNode());
        HierarchicalConfiguration result = new HierarchicalConfiguration();
        result.setRootNode(cn);
        return result;
    }

    @Test
    public void testInit() {
        Assert.assertTrue((String)"Combiner has list nodes", (boolean)this.combiner.getListNodes().isEmpty());
        Assert.assertFalse((String)"Node is list node", (boolean)this.combiner.isListNode((ConfigurationNode)new DefaultConfigurationNode("test")));
    }
}

