/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ExceptionUtils;
import org.opentest4j.AssertionFailedError;

class AssertTimeoutPreemptively {
    AssertTimeoutPreemptively() {
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, executable, (String)null);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, String message) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, () -> {
            executable.execute();
            return null;
        }, message);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier) {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier, null, AssertTimeoutPreemptively::createAssertionFailure);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, String message) {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier, message == null ? null : () -> message, AssertTimeoutPreemptively::createAssertionFailure);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertTimeoutPreemptively.assertTimeoutPreemptively(timeout, supplier, messageSupplier, AssertTimeoutPreemptively::createAssertionFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T, E extends Throwable> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier, Assertions.TimeoutFailureFactory<E> failureFactory) throws E {
        AtomicReference<Thread> threadReference = new AtomicReference<Thread>();
        ExecutorService executorService = Executors.newSingleThreadExecutor(new TimeoutThreadFactory());
        try {
            Future<T> future = AssertTimeoutPreemptively.submitTask(supplier, threadReference, executorService);
            T t = AssertTimeoutPreemptively.resolveFutureAndHandleException(future, timeout, messageSupplier, threadReference::get, failureFactory);
            return t;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private static <T> Future<T> submitTask(ThrowingSupplier<T> supplier, AtomicReference<Thread> threadReference, ExecutorService executorService) {
        return executorService.submit(() -> {
            try {
                threadReference.set(Thread.currentThread());
                return supplier.get();
            }
            catch (Throwable throwable) {
                throw ExceptionUtils.throwAsUncheckedException(throwable);
            }
        });
    }

    private static <T, E extends Throwable> T resolveFutureAndHandleException(Future<T> future, Duration timeout, Supplier<String> messageSupplier, Supplier<Thread> threadSupplier, Assertions.TimeoutFailureFactory<E> failureFactory) throws E {
        try {
            return future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            Thread thread = threadSupplier.get();
            ExecutionTimeoutException cause = null;
            if (thread != null) {
                cause = new ExecutionTimeoutException("Execution timed out in thread " + thread.getName());
                cause.setStackTrace(thread.getStackTrace());
            }
            throw failureFactory.createTimeoutFailure(timeout, messageSupplier, cause);
        }
        catch (ExecutionException ex) {
            throw ExceptionUtils.throwAsUncheckedException(ex.getCause());
        }
        catch (Throwable ex) {
            throw ExceptionUtils.throwAsUncheckedException(ex);
        }
    }

    private static AssertionFailedError createAssertionFailure(Duration timeout, Supplier<String> messageSupplier, Throwable cause) {
        return AssertionFailureBuilder.assertionFailure().message(messageSupplier).reason("execution timed out after " + timeout.toMillis() + " ms").cause(cause).build();
    }

    private static class TimeoutThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadNumber = new AtomicInteger(1);

        private TimeoutThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "junit-timeout-thread-" + threadNumber.getAndIncrement());
        }
    }

    private static class ExecutionTimeoutException
    extends JUnitException {
        private static final long serialVersionUID = 1L;

        ExecutionTimeoutException(String message) {
            super(message);
        }
    }
}

