/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.KnownBuiltInFunction;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SerializableCallable;
import org.mozilla.javascript.SerializableConstructable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;

public class LambdaConstructor
extends LambdaFunction {
    private static final long serialVersionUID = 2691205302914111400L;
    public static final int CONSTRUCTOR_FUNCTION = 1;
    public static final int CONSTRUCTOR_NEW = 2;
    public static final int CONSTRUCTOR_DEFAULT = 3;
    protected final SerializableConstructable targetConstructor;
    private final int flags;

    public LambdaConstructor(Scriptable scope, String name, int length, SerializableConstructable target) {
        super(scope, name, length, null);
        this.targetConstructor = target;
        this.flags = 3;
    }

    public LambdaConstructor(Scriptable scope, String name, int length, int flags, SerializableConstructable target) {
        super(scope, name, length, null);
        this.targetConstructor = target;
        this.flags = flags;
    }

    public LambdaConstructor(Scriptable scope, String name, int length, SerializableCallable target, SerializableConstructable targetConstructor) {
        super(scope, name, length, target, true);
        this.targetConstructor = targetConstructor;
        this.flags = (target != null ? 1 : 0) | (targetConstructor != null ? 2 : 0);
    }

    public LambdaConstructor(Scriptable scope, String name, int length, Object prototype, SerializableCallable target, SerializableConstructable targetConstructor) {
        super(scope, name, length, target, false);
        this.setPrototypeProperty(prototype);
        this.targetConstructor = targetConstructor;
        this.flags = (target != null ? 1 : 0) | (targetConstructor != null ? 2 : 0);
    }

    protected Constructable getTargetConstructor() {
        return this.targetConstructor;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if ((this.flags & 1) == 0) {
            throw ScriptRuntime.typeErrorById("msg.constructor.no.function", this.getFunctionName());
        }
        scope = this.getDeclarationScope();
        if (this.target == null) {
            return this.fireConstructor(cx, scope, args);
        }
        return this.target.call(cx, scope, thisObj, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if ((this.flags & 2) == 0) {
            throw ScriptRuntime.typeErrorById("msg.no.new", this.getFunctionName());
        }
        return this.fireConstructor(cx, this.getDeclarationScope(), args);
    }

    private Scriptable fireConstructor(Context cx, Scriptable scope, Object[] args) {
        Scriptable obj = this.targetConstructor.construct(cx, scope, args);
        obj.setPrototype(this.getClassPrototype());
        obj.setParentScope(scope);
        return obj;
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, SerializableCallable target) {
        this.definePrototypeMethod(scope, name, length, target, 2, 3);
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target, false);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeMethod(Scriptable scope, SymbolKey name, int length, SerializableCallable target) {
        this.definePrototypeMethod(scope, name, length, target, 2, 3);
    }

    public void definePrototypeMethod(Scriptable scope, SymbolKey name, int length, SerializableCallable target, int attributes) {
        this.definePrototypeMethod(scope, name, length, target, attributes, 3);
    }

    public void definePrototypeMethod(Scriptable scope, SymbolKey name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, "[" + name.getName() + "]", length, target, false);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeMethod(Scriptable scope, String name, int length, Object prototype, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, prototype, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void defineKnownBuiltInPrototypeMethod(Object tag, Scriptable scope, String name, int length, Object prototype, SerializableCallable target, int attributes, int propertyAttributes) {
        KnownBuiltInFunction f = new KnownBuiltInFunction(tag, scope, name, length, prototype, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeMethod(Scriptable scope, SymbolKey name, int length, Object prototype, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, "[" + name.getName() + "]", length, prototype, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, (Object)f, attributes);
    }

    public void definePrototypeProperty(String name, Object value, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(name, value, attributes);
    }

    public void definePrototypeProperty(Symbol key, Object value, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(key, value, attributes);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject descriptor) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineOwnProperty(cx, (Object)name, descriptor);
    }

    public void definePrototypeProperty(Context cx, Symbol key, ScriptableObject descriptor) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineOwnProperty(cx, (Object)key, descriptor);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject.LambdaGetterFunction getter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, name, getter, null, attributes);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject.LambdaGetterFunction getter) {
        this.definePrototypeProperty(cx, name, getter, 3);
    }

    public void definePrototypeProperty(Context cx, Symbol key, ScriptableObject.LambdaGetterFunction getter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, key, getter, null, attributes);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, name, getter, setter, attributes);
    }

    public void definePrototypeProperty(Context cx, String name, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter) {
        this.definePrototypeProperty(cx, name, getter, setter, 2);
    }

    public void definePrototypeProperty(Context cx, Symbol key, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        proto.defineProperty(cx, key, getter, setter, attributes);
    }

    public void definePrototypeProperty(Context cx, Symbol name, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter) {
        this.definePrototypeProperty(cx, name, getter, setter, 2);
    }

    public void definePrototypeAlias(String name, SymbolKey alias, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        Object val = proto.get(name, (Scriptable)proto);
        proto.defineProperty(alias, val, attributes);
    }

    public void definePrototypeAlias(String name, String alias, int attributes) {
        ScriptableObject proto = this.getPrototypeScriptable();
        Object val = proto.get(name, (Scriptable)proto);
        proto.defineProperty(alias, val, attributes);
    }

    public void defineConstructorMethod(Scriptable scope, String name, int length, SerializableCallable target) {
        this.defineConstructorMethod(scope, name, length, target, 2, 3);
    }

    public void defineConstructorMethod(Scriptable scope, Symbol key, String name, int length, SerializableCallable target) {
        this.defineConstructorMethod(scope, name, length, target);
    }

    public void defineConstructorMethod(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target, false);
        f.setStandardPropertyAttributes(propertyAttributes);
        this.defineProperty(name, (Object)f, attributes);
    }

    public void defineConstructorMethod(Scriptable scope, String name, int length, Object prototype, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, prototype, target);
        f.setStandardPropertyAttributes(propertyAttributes);
        this.defineProperty(name, (Object)f, attributes);
    }

    public void setPrototypeScriptable(ScriptableObject proto) {
        proto.setParentScope(this.getDeclarationScope());
        this.setPrototypeProperty(proto);
        Scriptable objectProto = LambdaConstructor.getObjectPrototype(this);
        if (proto != objectProto) {
            proto.setPrototype(objectProto);
        }
        proto.defineProperty("constructor", (Object)this, 2);
    }

    public static <T> T convertThisObject(Scriptable thisObj, Class<T> targetClass) {
        if (!targetClass.isInstance(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.this.not.instance", targetClass.getSimpleName());
        }
        return (T)thisObj;
    }

    private ScriptableObject getPrototypeScriptable() {
        Object prop = this.getPrototypeProperty();
        if (!(prop instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError("Not properly a lambda constructor");
        }
        return (ScriptableObject)prop;
    }
}

