/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.trans.XPathException;

public class ActiveStAXSource
implements ActiveSource {
    StAXSource underlyingSource;

    public ActiveStAXSource(StAXSource source) {
        this.underlyingSource = source;
    }

    public static ActiveStAXSource fromStAXSource(StAXSource source) throws XMLStreamException {
        if (source.getXMLStreamReader() != null) {
            return new ActiveStAXSource(source);
        }
        throw new XMLStreamException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
    }

    @Override
    public void setSystemId(String systemId) {
        this.underlyingSource.setSystemId(systemId);
    }

    @Override
    public String getSystemId() {
        return this.underlyingSource.getSystemId();
    }

    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        XMLStreamReader reader = this.underlyingSource.getXMLStreamReader();
        if (reader == null) {
            throw new XPathException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
        }
        StaxBridge bridge = new StaxBridge();
        bridge.setXMLStreamReader(reader);
        new PullSource(bridge).deliver(receiver, options);
    }
}

