/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class IdentitySequenceTest
extends GeneratedColumnsHelper {
    private static final String BAD_NEXT_VALUE = "42XAR";
    private static final String TABLE_DOESNT_HAVE_IDENTITY = "X0X81";

    public IdentitySequenceTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(IdentitySequenceTest.class));
        baseTestSuite.addTest((Test)cleanDatabaseTestSetup);
        return baseTestSuite;
    }

    public void test_001_catalog() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table T1_01_IST\n(\n    a int generated always as identity ( start with 10, increment by 20 ),\n    b int\n)\n");
        String string = IdentitySequenceTest.getIdentitySequenceName(connection, "T1_01_IST");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[][]{{"SYS", string, "10", "10", "-2147483648", "2147483647", "20", "N"}}, false);
        this.assertResults(connection, "values syscs_util.syscs_peek_at_identity( 'APP', 'T1_01_IST' )", new String[][]{{"10"}}, false);
        this.expectCompilationError(connection, BAD_NEXT_VALUE, "values ( next value for sys.\"" + string + "\" )");
        this.goodStatement(connection, "alter table T1_01_IST alter column a set increment by 15");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[][]{{"SYS", string, "10", "10", "-2147483648", "2147483647", "15", "N"}}, false);
        this.goodStatement(connection, "alter table T1_01_IST alter column a restart with 500");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[][]{{"SYS", string, "500", "500", "-2147483648", "2147483647", "15", "N"}}, false);
        this.goodStatement(connection, "drop table T1_01_IST");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[0][], false);
        this.goodStatement(connection, "create table T2_01_IST( b int )");
        this.goodStatement(connection, "alter table T2_01_IST add column a int generated always as identity ( start with 10, increment by 20 )");
        this.goodStatement(connection, "drop table T2_01_IST");
        this.goodStatement(connection, "create table T3_03_IST\n(\n    a int generated always as identity ( start with 10, increment by 20 ),\n    b int\n)\n");
        string = IdentitySequenceTest.getIdentitySequenceName(connection, "T3_03_IST");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[][]{{"SYS", string, "10", "10", "-2147483648", "2147483647", "20", "N"}}, false);
        this.assertResults(connection, "values syscs_util.syscs_peek_at_identity( 'APP', 'T3_03_IST' )", new String[][]{{"10"}}, false);
        this.goodStatement(connection, "alter table T3_03_IST drop column a");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[0][], false);
        this.expectExecutionError(connection, TABLE_DOESNT_HAVE_IDENTITY, "values syscs_util.syscs_peek_at_identity( 'APP', 'T3_03_IST' )");
    }

    public void test_002_alterTable() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table t1_002( a int, b int generated always as identity )");
        this.goodStatement(connection, "insert into t1_002( a ) values ( 100 ), ( 200 )");
        this.goodStatement(connection, "alter table t1_002 alter b set increment by 10");
        this.goodStatement(connection, "insert into t1_002( a ) values ( 300 ), ( 400 )");
        this.assertResults(connection, "select * from t1_002 order by a", new String[][]{{"100", "1"}, {"200", "2"}, {"300", "3"}, {"400", "13"}}, false);
        this.goodStatement(connection, "drop table t1_002");
        this.goodStatement(connection, "create table t1_002( a int, b int generated always as identity )");
        this.goodStatement(connection, "insert into t1_002( a ) values ( 100 ), ( 200 )");
        this.goodStatement(connection, "delete from t1_002 where a = 200");
        this.goodStatement(connection, "alter table t1_002 alter b set increment by 10");
        this.goodStatement(connection, "insert into t1_002( a ) values ( 300 ), ( 400 )");
        this.assertResults(connection, "select * from t1_002 order by a", new String[][]{{"100", "1"}, {"300", "3"}, {"400", "13"}}, false);
        this.goodStatement(connection, "alter table t1_002 alter b restart with 1000");
        this.goodStatement(connection, "insert into t1_002( a ) values ( 500 ), ( 600 )");
        this.assertResults(connection, "select * from t1_002 order by a", new String[][]{{"100", "1"}, {"300", "3"}, {"400", "13"}, {"500", "1000"}, {"600", "1010"}}, false);
    }

    public void test_003_identityTimeout() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.locks.waitTimeout', '1' )");
        this.goodStatement(connection, "create table t_timeout( a int generated always as identity, b int )");
        connection.setAutoCommit(false);
        try {
            PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count(*) from sys.syssequences with rs\n");
            this.getScalarInteger(preparedStatement);
            this.expectExecutionError(connection, "40XL1", "insert into t_timeout( b ) values ( 1 )");
        }
        finally {
            connection.setAutoCommit(true);
            this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.locks.waitTimeout', '60' )");
        }
    }

    public void testcycleOption() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 2147483647 INCREMENT BY 2 CYCLE) , b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.assertResults(connection, "select * from t", new String[][]{{"2147483647", "1"}, {"-2147483648", "2"}, {"-2147483646", "3"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 2147483647, INCREMENT BY 2, CYCLE) , b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.assertResults(connection, "select * from t", new String[][]{{"2147483647", "1"}, {"-2147483648", "2"}, {"-2147483646", "3"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 47), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"47", "1"}, {"48", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 47 INCREMENT BY 3), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"47", "1"}, {"50", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 47, INCREMENT BY 3), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"47", "1"}, {"50", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 47, INCREMENT BY 3), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"47", "1"}, {"50", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 2147483647, CYCLE), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.assertResults(connection, "select * from t", new String[][]{{"2147483647", "1"}, {"-2147483648", "2"}, {"-2147483647", "3"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(START WITH 2147483647 CYCLE), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.assertResults(connection, "select * from t", new String[][]{{"2147483647", "1"}, {"-2147483648", "2"}, {"-2147483647", "3"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(INCREMENT BY 3), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"1", "1"}, {"4", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(INCREMENT BY 3, CYCLE), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"1", "1"}, {"4", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(INCREMENT BY 3, CYCLE), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"1", "1"}, {"4", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(CYCLE), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"1", "1"}, {"2", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(increment by 4 start with 4), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"4", "1"}, {"8", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(CYCLE START WITH 2147483647 INCREMENT BY 2 ) , b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.assertResults(connection, "select * from t", new String[][]{{"2147483647", "1"}, {"-2147483648", "2"}, {"-2147483646", "3"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(start with 2147483647, increment by 7 cycle) , b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.assertResults(connection, "select * from t", new String[][]{{"2147483647", "1"}, {"-2147483648", "2"}, {"-2147483641", "3"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(cycle , increment by 4), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.assertResults(connection, "select * from t", new String[][]{{"1", "1"}, {"5", "2"}}, false);
        this.goodStatement(connection, "drop table t");
        this.expectCompilationError(connection, "42X01", "create table t( a int generated by default as identity ())");
        this.expectCompilationError(connection, "42X01", "create table t( a int generated by default as identity (start 47))");
        this.expectCompilationError(connection, "42X01", "create table t( a int generated by default as identity (increment 4))");
        this.expectCompilationError(connection, "42XAJ", "create table t(a int generated by default as identity (cycle cycle))");
        this.expectCompilationError(connection, "42XAJ", "create table t( a int generated by default as identity(start with 4 start with 8))");
        this.expectCompilationError(connection, "42X01", "create table t( a int generated by default as identity(start with 4 , , , cycle))");
        this.goodStatement(connection, "create table t( a int generated always as identity(start with 2147483647, increment by 4), b int)");
        this.expectExecutionError(connection, "2200H", "insert into t( b ) values ( 1 ), ( 2 )");
        this.goodStatement(connection, "drop table t");
        this.expectCompilationError(connection, "42X01", "create table t( a int generated always as identity(START WITH, 47))");
        this.expectCompilationError(connection, "42X01", "create table t( a int generated always as identity(START WITH 47 ,))");
        this.goodStatement(connection, "create table t( a int generated always as identity(start with 2147483647 cycle), b int)");
        this.goodStatement(connection, "alter table t alter column a set increment by 4");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(start with 7 increment by 2 cycle), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.goodStatement(connection, "alter table t alter column a set increment by 4");
        this.goodStatement(connection, "insert into t( b ) values ( 3 ), ( 4 )");
        this.assertResults(connection, "select * from t", new String[][]{{"7", "1"}, {"9", "2"}, {"11", "3"}, {"15", "4"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(increment by 2 cycle), b int)");
        this.goodStatement(connection, "alter table t alter column a restart with 2147483647");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( a int generated always as identity(start with 7 increment by 2 cycle), b int)");
        this.goodStatement(connection, "insert into t( b ) values ( 1 ), ( 2 )");
        this.goodStatement(connection, "alter table t alter column a restart with 50");
        this.goodStatement(connection, "insert into t( b ) values ( 3 ), ( 4 )");
        this.assertResults(connection, "select * from t", new String[][]{{"7", "1"}, {"9", "2"}, {"50", "3"}, {"52", "4"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table t( A_6852 int generated always as identity(start with 7 increment by 2 cycle), b_6852 int)");
        this.assertResults(connection, "select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC, AUTOINCREMENTCYCLE from sys.syscolumns where COLUMNNAME ='A_6852'", new String[][]{{"7", "7", "2", "true"}}, false);
        this.assertResults(connection, "select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC, AUTOINCREMENTCYCLE from sys.syscolumns where COLUMNNAME ='B_6852'", new String[][]{{null, null, null, "false"}}, false);
        this.goodStatement(connection, "drop table t");
        this.goodStatement(connection, "create table T_6852( A_6852 int generated always as identity(start with 7 increment by 2))");
        this.assertResults(connection, "select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC,  AUTOINCREMENTCYCLE  from sys.syscolumns where COLUMNNAME ='A_6852'", new String[][]{{"7", "7", "2", "false"}}, false);
        String string = IdentitySequenceTest.getIdentitySequenceName(connection, "T_6852");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[][]{{"SYS", string, "7", "7", "-2147483648", "2147483647", "2", "N"}}, false);
        this.goodStatement(connection, "drop table T_6852");
        this.goodStatement(connection, "create table T_6852( A_6852 int generated always as identity(start with 7 increment by 2 cycle))");
        string = IdentitySequenceTest.getIdentitySequenceName(connection, "T_6852");
        this.assertResults(connection, "select\n    c.schemaName, s.sequenceName, s.currentValue, s.startValue,\n    s.minimumValue, s.maximumValue, s.increment, s.cycleoption\nfrom sys.syssequences s, sys.sysschemas c\nwhere s.schemaID = c.schemaID\nand s.sequenceName = '" + string + "'", new String[][]{{"SYS", string, "7", "7", "-2147483648", "2147483647", "2", "Y"}}, false);
        this.goodStatement(connection, "drop table T_6852");
    }

    private int getScalarInteger(PreparedStatement preparedStatement) throws Exception {
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    public static String getIdentitySequenceName(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select tableID from sys.systables where tablename = ?");
        preparedStatement.setString(1, string.toUpperCase());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        preparedStatement.close();
        return IdentitySequenceTest.uuidToSequenceName(string2);
    }

    public static String uuidToSequenceName(String string) {
        return "U" + string.replace("-", "X");
    }
}

