/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeInserter;
import org.apache.derby.impl.store.access.sort.MergeScan;
import org.apache.derby.impl.store.access.sort.MergeScanRowSource;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortBufferRowSource;
import org.apache.derby.impl.store.access.sort.SortBufferScan;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class MergeSort
implements Sort {
    private static final int STATE_CLOSED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_INSERTING = 2;
    private static final int STATE_DONE_INSERTING = 3;
    private static final int STATE_SCANNING = 4;
    private static final int STATE_DONE_SCANNING = 5;
    private int state = 0;
    protected DataValueDescriptor[] template;
    protected ColumnOrdering[] columnOrdering;
    protected int[] columnOrderingMap;
    protected boolean[] columnOrderingAscendingMap;
    protected boolean[] columnOrderingNullsLowMap;
    SortObserver sortObserver;
    protected boolean alreadyInOrder;
    private MergeInserter inserter = null;
    private Scan scan = null;
    private Vector<Long> mergeRuns = null;
    private SortBuffer sortBuffer = null;
    int sortBufferMax;
    int sortBufferMin;
    static Properties properties = null;

    MergeSort() {
    }

    @Override
    public SortController open(TransactionManager tran) throws StandardException {
        SanityManager.ASSERT(this.state == 1);
        this.state = 2;
        this.inserter = new MergeInserter();
        if (!this.inserter.initialize(this, tran)) {
            throw StandardException.newException("XSAS6.S", new Object[0]);
        }
        return this.inserter;
    }

    @Override
    public ScanManager openSortScan(TransactionManager tran, boolean hold) throws StandardException {
        SanityManager.ASSERT(this.state == 3);
        if (this.mergeRuns == null || this.mergeRuns.size() == 0) {
            this.scan = new SortBufferScan(this, tran, this.sortBuffer, hold);
            this.sortBuffer = null;
        } else {
            MergeScan mscan;
            long containerId = this.createMergeRun(tran, this.sortBuffer);
            this.mergeRuns.addElement(containerId);
            if (this.mergeRuns.size() > 512 || this.mergeRuns.size() > this.sortBuffer.capacity()) {
                this.multiStageMerge(tran);
            }
            if (!(mscan = new MergeScan(this, tran, this.sortBuffer, this.mergeRuns, this.sortObserver, hold)).init(tran)) {
                throw StandardException.newException("XSAS6.S", new Object[0]);
            }
            this.scan = mscan;
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        this.state = 4;
        return this.scan;
    }

    @Override
    public ScanControllerRowSource openSortRowSource(TransactionManager tran) throws StandardException {
        SanityManager.ASSERT(this.state == 3);
        ScanControllerRowSource rowSource = null;
        if (this.mergeRuns == null || this.mergeRuns.size() == 0) {
            this.scan = new SortBufferRowSource(this.sortBuffer, tran, this.sortObserver, false, this.sortBufferMax);
            rowSource = (ScanControllerRowSource)((Object)this.scan);
            this.sortBuffer = null;
        } else {
            MergeScanRowSource msRowSource;
            long containerId = this.createMergeRun(tran, this.sortBuffer);
            this.mergeRuns.addElement(containerId);
            if (this.mergeRuns.size() > 512 || this.mergeRuns.size() > this.sortBuffer.capacity()) {
                this.multiStageMerge(tran);
            }
            if (!(msRowSource = new MergeScanRowSource(this, tran, this.sortBuffer, this.mergeRuns, this.sortObserver, false)).init(tran)) {
                throw StandardException.newException("XSAS6.S", new Object[0]);
            }
            this.scan = msRowSource;
            rowSource = msRowSource;
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        this.state = 4;
        return rowSource;
    }

    @Override
    public void drop(TransactionController tran) throws StandardException {
        if (this.inserter != null) {
            this.inserter.completedInserts();
        }
        this.inserter = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.template = null;
        this.columnOrdering = null;
        this.sortObserver = null;
        this.dropMergeRuns((TransactionManager)tran);
        this.state = 0;
    }

    private boolean checkColumnOrdering(DataValueDescriptor[] template, ColumnOrdering[] columnOrdering) {
        int templateNColumns = template.length;
        boolean[] seen = new boolean[templateNColumns];
        for (int i = 0; i < columnOrdering.length; ++i) {
            int colid = columnOrdering[i].getColumnId();
            if (colid < 0 || colid >= templateNColumns) {
                return false;
            }
            if (seen[colid]) {
                return false;
            }
            seen[colid] = true;
            DataValueDescriptor columnVal = RowUtil.getColumn(template, (FormatableBitSet)null, colid);
            if (columnVal != null) continue;
            return false;
        }
        return true;
    }

    void checkColumnTypes(DataValueDescriptor[] row) throws StandardException {
        int nCols = row.length;
        if (this.template.length != nCols) {
            SanityManager.THROWASSERT("template.length (" + this.template.length + ") expected to be = to nCols (" + nCols + ")");
            throw StandardException.newException("XSAS3.S", new Object[0]);
        }
        for (int colid = 0; colid < nCols; ++colid) {
            DataValueDescriptor col1 = row[colid];
            DataValueDescriptor col2 = this.template[colid];
            if (col1 == null) {
                SanityManager.THROWASSERT("col[" + colid + "]  is null");
            }
            if (col1.getClass() == col2.getClass()) continue;
            SanityManager.THROWASSERT("col1.getClass() (" + String.valueOf(col1.getClass()) + ") expected to be the same as col2.getClass() (" + String.valueOf(col2.getClass()) + ")");
        }
    }

    protected int compare(DataValueDescriptor[] r1, DataValueDescriptor[] r2) throws StandardException {
        int colsToCompare = this.columnOrdering.length;
        for (int i = 0; i < colsToCompare; ++i) {
            boolean nullsLow;
            int colid;
            int r;
            if (i == colsToCompare - 1 && this.sortObserver.deferrable()) {
                if (!this.sortObserver.deferred()) break;
                this.sortObserver.rememberDuplicate(r1);
            }
            if ((r = r1[colid = this.columnOrderingMap[i]].compare(r2[colid], nullsLow = this.columnOrderingNullsLowMap[i])) == 0) continue;
            if (this.columnOrderingAscendingMap[i]) {
                return r;
            }
            return -r;
        }
        return 0;
    }

    public void initialize(DataValueDescriptor[] template, ColumnOrdering[] columnOrdering, SortObserver sortObserver, boolean alreadyInOrder, long estimatedRows, int sortBufferMax) throws StandardException {
        SanityManager.ASSERT(this.state == 0);
        SanityManager.ASSERT(this.checkColumnOrdering(template, columnOrdering), "column ordering error");
        this.template = template;
        this.columnOrdering = columnOrdering;
        this.sortObserver = sortObserver;
        this.alreadyInOrder = alreadyInOrder;
        this.columnOrderingMap = new int[columnOrdering.length];
        this.columnOrderingAscendingMap = new boolean[columnOrdering.length];
        this.columnOrderingNullsLowMap = new boolean[columnOrdering.length];
        for (int i = 0; i < columnOrdering.length; ++i) {
            this.columnOrderingMap[i] = columnOrdering[i].getColumnId();
            this.columnOrderingAscendingMap[i] = columnOrdering[i].getIsAscending();
            this.columnOrderingNullsLowMap[i] = columnOrdering[i].getIsNullsOrderedLow();
        }
        this.inserter = null;
        this.scan = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
        this.sortBufferMax = sortBufferMax;
        this.sortBufferMin = estimatedRows > (long)sortBufferMax ? sortBufferMax : (int)estimatedRows;
        if (SanityManager.DEBUG_ON("testSort")) {
            this.sortBufferMin = sortBufferMax;
        }
        this.state = 1;
    }

    void doneInserting(MergeInserter inserter, SortBuffer sortBuffer, Vector<Long> mergeRuns) {
        SanityManager.ASSERT(this.state == 2);
        this.sortBuffer = sortBuffer;
        this.mergeRuns = mergeRuns;
        this.inserter = null;
        this.state = 3;
    }

    void doneScanning(Scan scan, SortBuffer sortBuffer) {
        if (this.scan != scan) {
            SanityManager.THROWASSERT("this.scan = " + String.valueOf(this.scan) + " scan = " + String.valueOf(scan));
        }
        this.sortBuffer = sortBuffer;
        this.scan = null;
        this.state = 5;
    }

    void doneScanning(Scan scan, SortBuffer sortBuffer, Vector<Long> mergeRuns) {
        this.mergeRuns = mergeRuns;
        this.doneScanning(scan, sortBuffer);
    }

    void dropMergeRuns(TransactionManager tran) {
        if (this.mergeRuns != null) {
            Enumeration<Long> e = this.mergeRuns.elements();
            try {
                Transaction rawTran = tran.getRawStoreXact();
                long segmentId = -1L;
                while (e.hasMoreElements()) {
                    long containerId = e.nextElement();
                    rawTran.dropStreamContainer(segmentId, containerId);
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            this.mergeRuns = null;
        }
    }

    private void multiStageMerge(TransactionManager tran) throws StandardException {
        int maxMergeRuns = this.sortBuffer.capacity();
        if (maxMergeRuns > 512) {
            maxMergeRuns = 512;
        }
        while (this.mergeRuns.size() > maxMergeRuns) {
            Vector<Long> subset = new Vector<Long>(maxMergeRuns);
            Vector<Long> leftovers = new Vector<Long>(this.mergeRuns.size() - maxMergeRuns);
            Enumeration<Long> e = this.mergeRuns.elements();
            while (e.hasMoreElements()) {
                Long containerId = e.nextElement();
                if (subset.size() < maxMergeRuns) {
                    subset.addElement(containerId);
                    continue;
                }
                leftovers.addElement(containerId);
            }
            this.mergeRuns = leftovers;
            MergeScanRowSource msRowSource = new MergeScanRowSource(this, tran, this.sortBuffer, subset, this.sortObserver, false);
            if (!msRowSource.init(tran)) {
                throw StandardException.newException("XSAS6.S", new Object[0]);
            }
            Transaction rawTran = tran.getRawStoreXact();
            int segmentId = -1;
            long id = rawTran.addAndLoadStreamContainer(segmentId, properties, msRowSource);
            this.mergeRuns.addElement(id);
            e = subset.elements();
            while (e.hasMoreElements()) {
                Long containerId = e.nextElement();
                rawTran.dropStreamContainer(segmentId, containerId);
            }
        }
    }

    long createMergeRun(TransactionManager tran, SortBuffer sortBuffer) throws StandardException {
        SortBufferRowSource rowSource = new SortBufferRowSource(sortBuffer, null, this.sortObserver, true, this.sortBufferMax);
        Transaction rawTran = tran.getRawStoreXact();
        int segmentId = -1;
        long id = rawTran.addAndLoadStreamContainer(segmentId, properties, rowSource);
        rowSource = null;
        return id;
    }

    static {
        properties = new Properties();
        properties.put("derby.storage.streamFileBufferSize", "16384");
    }
}

