/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import junit.framework.Test;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.client.am.stmtcache.StatementKeyFactory;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementKeyFactoryTest
extends BaseTestCase {
    public StatementKeyFactoryTest(String string) {
        super(string);
    }

    public void testCreationBasicWithNulls() {
        try {
            StatementKeyFactory.newPrepared(null, null, (int)0);
            StatementKeyFactoryTest.fail((String)"Creation with <null> should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StatementKeyFactory.newPrepared(null, (String)"app", (int)0);
            StatementKeyFactoryTest.fail((String)"Creation with <null> should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StatementKeyFactory.newPrepared((String)"values 1", null, (int)0);
            StatementKeyFactoryTest.fail((String)"Creation with <null> should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreationBasic() {
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)"values 1", (String)"APP", (int)1);
        StatementKey statementKey2 = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKeyFactoryTest.assertFalse((boolean)statementKey2.equals((Object)statementKey));
        StatementKeyFactoryTest.assertFalse((boolean)statementKey.equals((Object)statementKey2));
    }

    public void testEqualityBasic() {
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKey statementKey2 = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKey statementKey3 = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKeyFactoryTest.assertTrue((boolean)statementKey.equals((Object)statementKey2));
        StatementKeyFactoryTest.assertTrue((boolean)statementKey2.equals((Object)statementKey));
        StatementKeyFactoryTest.assertTrue((boolean)statementKey2.equals((Object)statementKey3));
        StatementKeyFactoryTest.assertTrue((boolean)statementKey.equals((Object)statementKey3));
    }

    public void testEqualityDefaultNoAutoGenKey() {
        int n = 1;
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)n);
        StatementKey statementKey2 = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)n, (int)2);
        StatementKeyFactoryTest.assertTrue((boolean)statementKey.equals((Object)statementKey2));
        StatementKeyFactoryTest.assertTrue((boolean)statementKey2.equals((Object)statementKey));
    }

    public void testEqualityNoAutoVsAutoGenKey() {
        int n = 1;
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)n);
        StatementKey statementKey2 = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)n, (int)1);
        StatementKeyFactoryTest.assertFalse((boolean)statementKey.equals((Object)statementKey2));
        StatementKeyFactoryTest.assertFalse((boolean)statementKey2.equals((Object)statementKey));
    }

    public void testUnequalityVarious() {
        String string = "select * from sys.systables";
        String string2 = "APP";
        int n = 1;
        int n2 = 1004;
        int n3 = 1008;
        int n4 = 1;
        StatementKey[] statementKeyArray = new StatementKey[]{StatementKeyFactory.newPrepared((String)string, (String)string2, (int)n), StatementKeyFactory.newPrepared((String)string, (String)string2, (int)n, (int)n4), StatementKeyFactory.newPrepared((String)string, (String)string2, (int)n2, (int)n3, (int)n), StatementKeyFactory.newCallable((String)string, (String)string2, (int)n), StatementKeyFactory.newCallable((String)string, (String)string2, (int)n2, (int)n3, (int)n)};
        for (int i = 0; i < statementKeyArray.length; ++i) {
            StatementKey statementKey = statementKeyArray[i];
            for (int j = 0; j < statementKeyArray.length; ++j) {
                if (i != j) {
                    if (!statementKey.equals((Object)statementKeyArray[j])) continue;
                    StatementKeyFactoryTest.fail((String)("[" + statementKey.toString() + "] should not equal [" + statementKeyArray[j].toString() + "]"));
                    continue;
                }
                StatementKeyFactoryTest.assertTrue((boolean)statementKey.equals((Object)statementKeyArray[j]));
            }
        }
    }

    public void testCallableVsPrepared() {
        String string = "select colA, colB from mytable";
        String string2 = "SOMEAPP";
        int n = 1;
        StatementKey statementKey = StatementKeyFactory.newCallable((String)string, (String)string2, (int)n);
        StatementKey statementKey2 = StatementKeyFactory.newPrepared((String)string, (String)string2, (int)n);
        StatementKeyFactoryTest.assertFalse((boolean)statementKey.equals((Object)statementKey2));
        StatementKeyFactoryTest.assertFalse((boolean)statementKey2.equals((Object)statementKey));
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(StatementKeyFactoryTest.class);
    }
}

