/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestGrammar;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseContainer;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseStates;
import org.apache.directory.api.ldap.codec.controls.sort.StoreSortResponseResultCode;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SortResponseGrammar
extends AbstractGrammar<SortResponseContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SortRequestGrammar.class);
    private static Grammar<SortResponseContainer> instance = new SortResponseGrammar();

    private SortResponseGrammar() {
        this.setName(SortResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[SortResponseStates.END_STATE.ordinal()][256];
        this.transitions[SortResponseStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SortResponseStates.START_STATE, SortResponseStates.SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortResponseStates.SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition(SortResponseStates.SEQUENCE_STATE, SortResponseStates.RESULT_CODE_STATE, UniversalTag.ENUMERATED.getValue(), new StoreSortResponseResultCode());
        this.transitions[SortResponseStates.RESULT_CODE_STATE.ordinal()][128] = new GrammarTransition<SortResponseContainer>(SortResponseStates.RESULT_CODE_STATE, SortResponseStates.AT_DESC_STATE, 128, new GrammarAction<SortResponseContainer>(){

            @Override
            public void action(SortResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String atType = Strings.utf8ToString(value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05310_ATTRIBUTE_TYPE, atType));
                }
                container.getControl().setAttributeName(atType);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

