/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class URLEncoder {
    public static String charset = "UTF8";

    private URLEncoder() {
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(charset);
        }
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        if (!URLEncoder.needsEncoding(s)) {
            return s;
        }
        int length = s.length();
        StringBuffer out = new StringBuffer(length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(10);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        for (int i = 0; i < length; ++i) {
            int c = s.charAt(i);
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 32) {
                if (c == 32) {
                    c = 43;
                }
                URLEncoder.toHex(out, buf.toByteArray());
                buf.reset();
                out.append((char)c);
                continue;
            }
            try {
                char d;
                writer.write(c);
                if (c >= 55296 && c <= 56319 && i < length - 1 && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    writer.write(d);
                    ++i;
                }
                writer.flush();
                continue;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(s);
            }
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        URLEncoder.toHex(out, buf.toByteArray());
        return out.toString();
    }

    private static void toHex(StringBuffer buffer, byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            buffer.append('%');
            char ch = Character.forDigit(b[i] >> 4 & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            buffer.append(ch);
            ch = Character.forDigit(b[i] & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - 32);
            }
            buffer.append(ch);
        }
    }

    private static boolean needsEncoding(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return true;
        }
        return false;
    }
}

