/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.grails.compiler.gorm

import groovy.transform.CompileStatic
import org.codehaus.groovy.ast.ASTNode
import org.codehaus.groovy.ast.AnnotatedNode
import org.codehaus.groovy.ast.AnnotationNode
import org.codehaus.groovy.ast.ClassNode
import org.codehaus.groovy.control.CompilePhase
import org.codehaus.groovy.control.SourceUnit
import org.codehaus.groovy.transform.GroovyASTTransformation

import grails.gorm.annotation.JpaEntity
import org.apache.grails.common.compiler.GroovyTransformOrder

/**
 * Enhanced GORM entity annotated with JPA annotations
 *
 * @author Graeme Rocher
 * @since 6.1
 */
@CompileStatic
@GroovyASTTransformation(phase = CompilePhase.CANONICALIZATION)
class JpaGormEntityTransformation extends GormEntityTransformation {

    private static final ClassNode MY_TYPE = new ClassNode(JpaEntity)

    @Override
    void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        AnnotatedNode parent = (AnnotatedNode) astNodes[1]
        AnnotationNode node = (AnnotationNode) astNodes[0]

        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: ${node.getClass()} / ${parent.getClass()}")
        }

        if (!MY_TYPE.equals(node.getClassNode()) || !(parent instanceof ClassNode)) {
            return
        }

        ClassNode cNode = (ClassNode) parent

        visit(cNode, sourceUnit)
    }

    @Override
    void visit(ClassNode classNode, SourceUnit sourceUnit) {
        if (!hasAnnotation(classNode, JPA_ENTITY_CLASS_NODE)) {
            classNode.addAnnotation(JPA_ENTITY_ANNOTATION_NODE)
        }
        super.visit(classNode, sourceUnit)
    }

    @Override
    int priority() {
        GroovyTransformOrder.JPA_GORM_ENTITY_ORDER
    }
}
