/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

public class ParserException
extends RuntimeException {
    private final int lineNumber;
    private final int columnNumber;
    private final String templatePath;

    public ParserException(int lineNumber, int columnNumber, String templatePath, String msg, Throwable cause) {
        super(ParserException.buildMessage(lineNumber, columnNumber, templatePath, msg, cause), cause);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.templatePath = templatePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    private static String buildMessage(int lineNumber, int columnNumber, String templatePath, String message, Throwable cause) {
        StringBuilder s = new StringBuilder();
        if (templatePath != null) {
            s.append(templatePath);
        }
        if (lineNumber >= 0) {
            s.append(":[");
            s.append(lineNumber);
            s.append(",");
            s.append(columnNumber);
            s.append("] ");
        } else {
            s.append(" ");
        }
        if (message != null) {
            s.append(message);
        } else if (cause != null) {
            s.append(cause.getClass().getSimpleName());
        }
        return s.toString();
    }
}

