/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.configuration;

import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.PropertyMetadata;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class ConfigurationMetadataBuilder<T> {
    private static ConfigurationMetadataBuilder<?> currentBuilder = null;
    private final List<PropertyMetadata> properties = new ArrayList<PropertyMetadata>();
    private final List<ConfigurationMetadata> configurations = new ArrayList<ConfigurationMetadata>();

    @NonNull
    public abstract Element[] getOriginatingElements();

    public List<PropertyMetadata> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public List<ConfigurationMetadata> getConfigurations() {
        return Collections.unmodifiableList(this.configurations);
    }

    public boolean hasMetadata() {
        return !this.properties.isEmpty() || !this.configurations.isEmpty();
    }

    public ConfigurationMetadata visitProperties(T type, @Nullable String description) {
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata(type);
        return this.visitProperties(type, description, annotationMetadata);
    }

    public ConfigurationMetadata visitProperties(T type, @Nullable String description, @NonNull AnnotationMetadata annotationMetadata) {
        String path = this.buildTypePath(type, type, annotationMetadata);
        ConfigurationMetadata configurationMetadata = new ConfigurationMetadata();
        configurationMetadata.name = NameUtils.hyphenate(path, true);
        configurationMetadata.type = this.getTypeString(type);
        configurationMetadata.description = description;
        configurationMetadata.includes = CollectionUtils.setOf(annotationMetadata.stringValues(ConfigurationReader.class, "includes"));
        configurationMetadata.excludes = CollectionUtils.setOf(annotationMetadata.stringValues(ConfigurationReader.class, "excludes"));
        this.configurations.add(configurationMetadata);
        return configurationMetadata;
    }

    public PropertyMetadata visitProperty(T owningType, T declaringType, String propertyType, String name, @Nullable String description, @Nullable String defaultValue) {
        PropertyMetadata metadata = new PropertyMetadata();
        metadata.declaringType = this.getTypeString(declaringType);
        metadata.name = name;
        metadata.path = NameUtils.hyphenate(this.buildPropertyPath(owningType, declaringType, name), true);
        metadata.type = propertyType;
        metadata.description = description;
        metadata.defaultValue = defaultValue;
        this.properties.add(metadata);
        return metadata;
    }

    public PropertyMetadata visitProperty(String propertyType, String name, @Nullable String description, @Nullable String defaultValue) {
        if (!this.configurations.isEmpty()) {
            ConfigurationMetadata last = this.configurations.get(this.configurations.size() - 1);
            PropertyMetadata metadata = new PropertyMetadata();
            metadata.declaringType = last.type;
            metadata.name = name;
            metadata.path = NameUtils.hyphenate(last.name + "." + name, true);
            metadata.type = propertyType;
            metadata.description = description;
            metadata.defaultValue = defaultValue;
            this.properties.add(metadata);
            return metadata;
        }
        return null;
    }

    protected abstract String buildPropertyPath(T var1, T var2, String var3);

    protected abstract String buildTypePath(T var1, T var2);

    protected abstract String buildTypePath(T var1, T var2, AnnotationMetadata var3);

    protected abstract String getTypeString(T var1);

    protected abstract AnnotationMetadata getAnnotationMetadata(T var1);

    public static Optional<ConfigurationMetadataBuilder<?>> getConfigurationMetadataBuilder() {
        return Optional.ofNullable(currentBuilder);
    }

    public static void setConfigurationMetadataBuilder(@Nullable ConfigurationMetadataBuilder<?> builder) {
        currentBuilder = builder;
    }

    static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i2 = 0; i2 < len; ++i2) {
            c = string.charAt(i2);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    static void writeAttribute(Writer out, String name, String value) throws IOException {
        out.write(34);
        out.write(name);
        out.write("\":");
        out.write(ConfigurationMetadataBuilder.quote(value));
    }
}

