/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.options;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.options.BuildTool;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.ServletImpl;
import org.grails.forge.options.TestFramework;
import org.grails.forge.util.VersionInfo;

public class Options
implements ConvertibleValues<Object> {
    private final OperatingSystem operatingSystem;
    private final TestFramework testFramework;
    private final BuildTool buildTool;
    private final GormImpl gormImpl;
    private final ServletImpl servletImpl;
    private final JdkVersion javaVersion;
    private final ConvertibleValuesMap<Object> additionalOptions;

    public Options(TestFramework testFramework, GormImpl gormImpl, ServletImpl servletImpl, JdkVersion javaVersion, OperatingSystem operatingSystem, Map<String, Object> additionalOptions) {
        this.testFramework = testFramework;
        this.buildTool = BuildTool.DEFAULT_OPTION;
        this.gormImpl = gormImpl;
        this.servletImpl = servletImpl;
        this.javaVersion = javaVersion;
        this.operatingSystem = operatingSystem;
        this.additionalOptions = new ConvertibleValuesMap<Object>(additionalOptions);
    }

    public Options(TestFramework testFramework, GormImpl gormImpl, ServletImpl servletImpl, JdkVersion javaVersion, OperatingSystem operatingSystem) {
        this(testFramework, gormImpl, servletImpl, javaVersion, operatingSystem, Collections.emptyMap());
    }

    public Options(TestFramework testFramework, JdkVersion javaVersion, OperatingSystem operatingSystem) {
        this(testFramework, GormImpl.DEFAULT_OPTION, ServletImpl.DEFAULT_OPTION, javaVersion, operatingSystem, Collections.emptyMap());
    }

    public Options(TestFramework testFramework, OperatingSystem operatingSystem) {
        this(testFramework, GormImpl.DEFAULT_OPTION, ServletImpl.DEFAULT_OPTION, VersionInfo.getJavaVersion(), operatingSystem, Collections.emptyMap());
    }

    public Options(TestFramework testFramework, GormImpl gormImpl, ServletImpl servletImpl, JdkVersion javaVersion) {
        this(testFramework, gormImpl, servletImpl, javaVersion, OperatingSystem.DEFAULT, Collections.emptyMap());
    }

    public Options(TestFramework testFramework, JdkVersion javaVersion) {
        this(testFramework, GormImpl.DEFAULT_OPTION, ServletImpl.DEFAULT_OPTION, javaVersion, OperatingSystem.DEFAULT, Collections.emptyMap());
    }

    public Options(TestFramework testFramework) {
        this(testFramework, GormImpl.DEFAULT_OPTION, ServletImpl.DEFAULT_OPTION, JdkVersion.DEFAULT_OPTION, OperatingSystem.DEFAULT, Collections.emptyMap());
    }

    public Options() {
        this(TestFramework.DEFAULT_OPTION, GormImpl.DEFAULT_OPTION, ServletImpl.DEFAULT_OPTION, JdkVersion.DEFAULT_OPTION, OperatingSystem.DEFAULT, Collections.emptyMap());
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public TestFramework getTestFramework() {
        return this.testFramework;
    }

    public BuildTool getBuildTool() {
        return this.buildTool;
    }

    public GormImpl getGormImpl() {
        return this.gormImpl;
    }

    public ServletImpl getServletImpl() {
        return this.servletImpl;
    }

    @Override
    public Set<String> names() {
        return this.additionalOptions.names();
    }

    @Override
    public Collection<Object> values() {
        return this.additionalOptions.values();
    }

    @Override
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.additionalOptions.get(name, conversionContext);
    }

    public JdkVersion getJavaVersion() {
        return this.javaVersion;
    }

    public Options withOperatingSystem(OperatingSystem operatingSystem) {
        return new Options(this.testFramework, this.gormImpl, this.servletImpl, this.javaVersion, operatingSystem, this.additionalOptions.asMap());
    }

    public Options withTestFramework(TestFramework testFramework) {
        return new Options(testFramework, this.gormImpl, this.servletImpl, this.javaVersion, this.operatingSystem, this.additionalOptions.asMap());
    }

    public Options withGormImpl(GormImpl gormImpl) {
        return new Options(this.testFramework, gormImpl, this.servletImpl, this.javaVersion, this.operatingSystem, this.additionalOptions.asMap());
    }

    public Options withServletImpl(ServletImpl servletImpl) {
        return new Options(this.testFramework, this.gormImpl, servletImpl, this.javaVersion, this.operatingSystem, this.additionalOptions.asMap());
    }

    public Options withJavaVersion(JdkVersion javaVersion) {
        return new Options(this.testFramework, this.gormImpl, this.servletImpl, javaVersion, this.operatingSystem, this.additionalOptions.asMap());
    }
}

