/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.scheduling.NextFireTime;
import io.micronaut.scheduling.ReschedulingTask;
import io.micronaut.scheduling.TaskScheduler;
import io.micronaut.scheduling.cron.CronExpression;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.ZoneId;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Named(value="scheduled")
@Primary
@Singleton
public class ScheduledExecutorTaskScheduler
implements TaskScheduler {
    private final ScheduledExecutorService executorService;

    public ScheduledExecutorTaskScheduler(@Named(value="scheduled") ExecutorService executorService) {
        if (!(executorService instanceof ScheduledExecutorService)) {
            throw new IllegalStateException("Cannot schedule tasks on ExecutorService that is not a ScheduledExecutorService: " + executorService);
        }
        this.executorService = (ScheduledExecutorService)executorService;
    }

    @Override
    public ScheduledFuture<?> schedule(String cron, Runnable command) {
        return this.schedule(cron, null, command);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(String cron, Callable<V> command) {
        return this.schedule(cron, null, command);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@NonNull String cron, @Nullable String timezoneId, @NonNull Callable<V> command) {
        ZoneId zoneId;
        if (StringUtils.isEmpty((CharSequence)cron)) {
            throw new IllegalArgumentException("Blank cron expression not allowed");
        }
        ArgumentUtils.check((String)"command", command).notNull();
        if (timezoneId == null || timezoneId.equals("")) {
            zoneId = ZoneId.systemDefault();
        } else {
            try {
                zoneId = ZoneId.of(timezoneId);
            }
            catch (Exception e) {
                zoneId = null;
            }
        }
        if (zoneId == null) {
            throw new IllegalArgumentException("Invalid zone id for cron expression");
        }
        NextFireTime delaySupplier = new NextFireTime(CronExpression.create(cron), zoneId);
        return new ReschedulingTask<V>(command, this, delaySupplier);
    }

    @Override
    public ScheduledFuture<?> schedule(Duration delay, Runnable command) {
        ArgumentUtils.check((String)"delay", (Object)delay).notNull();
        ArgumentUtils.check((String)"command", (Object)command).notNull();
        return this.executorService.schedule(command, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Duration delay, Callable<V> callable) {
        ArgumentUtils.check((String)"delay", (Object)delay).notNull();
        ArgumentUtils.check((String)"callable", callable).notNull();
        return this.executorService.schedule(callable, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Duration initialDelay, Duration period, Runnable command) {
        ArgumentUtils.check((String)"period", (Object)period).notNull();
        ArgumentUtils.check((String)"command", (Object)command).notNull();
        long initialDelayMillis = initialDelay != null ? initialDelay.toMillis() : 0L;
        return this.executorService.scheduleAtFixedRate(command, initialDelayMillis, period.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Duration initialDelay, Duration delay, Runnable command) {
        ArgumentUtils.check((String)"delay", (Object)delay).notNull();
        ArgumentUtils.check((String)"command", (Object)command).notNull();
        long initialDelayMillis = initialDelay != null ? initialDelay.toMillis() : 0L;
        return this.executorService.scheduleWithFixedDelay(command, initialDelayMillis, delay.toMillis(), TimeUnit.MILLISECONDS);
    }
}

