/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.TupleMarshaller;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerImpl;
import org.jetbrains.annotations.Nullable;

class TupleMarshallerCache {
    private final SchemaRegistry schemaRegistry;
    @Nullable
    private volatile TupleMarshaller cachedMarshaller;

    TupleMarshallerCache(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    TupleMarshaller marshaller(int schemaVersion) {
        TupleMarshaller marshaller = this.cachedMarshaller;
        if (marshaller != null && marshaller.schemaVersion() == schemaVersion) {
            return marshaller;
        }
        this.cachedMarshaller = marshaller = new TupleMarshallerImpl(this.schemaRegistry.schema(schemaVersion));
        return marshaller;
    }
}

