/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.compute.PojoConversionException;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.PojoMapper;

public class PojoConverter {
    private static final Set<Class<?>> NATIVE_TYPES = Arrays.stream(ColumnType.values()).map(ColumnType::javaClass).collect(Collectors.toUnmodifiableSet());

    public static Tuple toTuple(Object obj) throws PojoConversionException {
        PojoMapper mapper;
        Class<?> clazz = obj.getClass();
        try {
            mapper = (PojoMapper)Mapper.of(clazz);
        }
        catch (IllegalArgumentException e) {
            throw new PojoConversionException("Class " + clazz.getName() + " doesn't contain any marshallable fields", (Throwable)e);
        }
        Tuple tuple = Tuple.create();
        Collection<String> fields = mapper.fields();
        for (String fieldName : fields) {
            try {
                String columnName = "\"" + fieldName + "\"";
                Field field = clazz.getDeclaredField(fieldName);
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
                VarHandle varHandle = lookup.unreflectVarHandle(field);
                tuple.set(columnName, PojoConverter.convertToTupleIfNeeded(field, varHandle.get(obj)));
            }
            catch (IllegalAccessException e) {
                throw new PojoConversionException("Cannot access field `" + fieldName + "`", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new PojoConversionException("Field `" + fieldName + "` was not found", (Throwable)e);
            }
        }
        return tuple;
    }

    public static void fromTuple(Object obj, Tuple tuple) {
        Class<?> clazz = obj.getClass();
        for (int i = 0; i < tuple.columnCount(); ++i) {
            String columnName = tuple.columnName(i);
            String fieldName = columnName.substring(1, columnName.length() - 1);
            Field field = PojoConverter.getField(clazz, fieldName);
            Object value = tuple.value(i);
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
                VarHandle varHandle = lookup.unreflectVarHandle(field);
                varHandle.set(obj, PojoConverter.convertFromNestedTupleIfNeeded(field, value));
                continue;
            }
            catch (UnsupportedOperationException e) {
                throw new PojoConversionException("Field for the column `" + fieldName + "` is final", (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new PojoConversionException("Incompatible types: Field `" + fieldName + "` has a type " + field.getType() + " while deserializing type " + value.getClass(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PojoConversionException("Field for the column `" + fieldName + "` is not accessible", (Throwable)e);
            }
        }
    }

    private static Object convertToTupleIfNeeded(Field field, Object obj) {
        if (PojoConverter.isNativeType(field.getType())) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        return PojoConverter.toTuple(obj);
    }

    private static Object convertFromNestedTupleIfNeeded(Field field, Object value) throws IllegalAccessException {
        if (PojoConverter.isNativeType(field.getType())) {
            return value;
        }
        if (value == null) {
            return null;
        }
        try {
            Object obj = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            PojoConverter.fromTuple(obj, (Tuple)value);
            return obj;
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PojoConversionException("Field for the column `" + field.getName() + "` cannot be converted", (Throwable)e);
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new PojoConversionException("Field `" + fieldName + "` was not found", (Throwable)e);
        }
    }

    private static boolean isNativeType(Class<?> clazz) {
        return NATIVE_TYPES.contains(clazz) || clazz.isPrimitive();
    }
}

