/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.recovery.system;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Controller;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.disaster.system.SystemDisasterRecoveryManager;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.recovery.system.MigrateRequest;
import org.apache.ignite3.internal.rest.api.recovery.system.ResetClusterRequest;
import org.apache.ignite3.internal.rest.api.recovery.system.SystemDisasterRecoveryApi;
import org.apache.ignite3.internal.rest.exception.handler.ClusterResetExceptionHandler;
import org.apache.ignite3.internal.rest.exception.handler.IgniteInternalExceptionHandler;
import org.apache.ignite3.internal.rest.exception.handler.MigrateExceptionHandler;

@Controller(value="/management/v1/recovery/cluster/")
@Requires(classes={ClusterResetExceptionHandler.class, MigrateExceptionHandler.class, IgniteInternalExceptionHandler.class})
public class SystemDisasterRecoveryController
implements SystemDisasterRecoveryApi,
ResourceHolder {
    private static final IgniteLogger LOG = Loggers.forClass(SystemDisasterRecoveryController.class);
    private SystemDisasterRecoveryManager systemDisasterRecoveryManager;
    private final CmgMessagesFactory cmgMessagesFactory = new CmgMessagesFactory();

    public SystemDisasterRecoveryController(SystemDisasterRecoveryManager systemDisasterRecoveryManager) {
        this.systemDisasterRecoveryManager = systemDisasterRecoveryManager;
    }

    @Override
    public CompletableFuture<Void> reset(ResetClusterRequest command) {
        LOG.info("Reset command is {}", command);
        if (command.metastorageRepairRequested()) {
            return this.systemDisasterRecoveryManager.resetClusterRepairingMetastorage(command.cmgNodeNames(), command.metastorageReplicationFactor());
        }
        return this.systemDisasterRecoveryManager.resetCluster(command.cmgNodeNames());
    }

    @Override
    public CompletableFuture<Void> migrate(MigrateRequest command) {
        LOG.info("Migrate command is {}", command);
        return this.systemDisasterRecoveryManager.migrate(this.migrateRequestToClusterState(command));
    }

    private ClusterState migrateRequestToClusterState(MigrateRequest command) {
        List<UUID> formerClusterIds = command.formerClusterIds();
        return this.cmgMessagesFactory.clusterState().cmgNodes(Set.copyOf(command.cmgNodes())).metaStorageNodes(Set.copyOf(command.metaStorageNodes())).version(command.version()).clusterTag(ClusterTag.clusterTag(this.cmgMessagesFactory, command.clusterName(), command.clusterId())).formerClusterIds(formerClusterIds == null ? null : List.copyOf(formerClusterIds)).build();
    }

    @Override
    public void cleanResources() {
        this.systemDisasterRecoveryManager = null;
    }
}

