/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.GetLeaderRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.GetLeaderRequestSerializer;

public class GetLeaderRequestImpl
implements CliRequests.GetLeaderRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1009;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;

    private GetLeaderRequestImpl(String groupId, String peerId) {
        this.groupId = groupId;
        this.peerId = peerId;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    public MessageSerializer serializer() {
        return GetLeaderRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetLeaderRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 1009;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetLeaderRequestImpl otherMessage = (GetLeaderRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.peerId);
        return result;
    }

    @Override
    public GetLeaderRequestImpl clone() {
        try {
            return (GetLeaderRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetLeaderRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetLeaderRequestBuilder {
        private String groupId;
        private String peerId;

        private Builder() {
        }

        @Override
        public GetLeaderRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public GetLeaderRequestBuilder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public CliRequests.GetLeaderRequest build() {
            return new GetLeaderRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.peerId);
        }
    }
}

