/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.storage.file.assit;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaOutter;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.io.MessageFile;

public abstract class Checkpoint {
    private final String path;
    private final RaftMessagesFactory raftMessagesFactory;

    public Checkpoint(String path, RaftOptions raftOptions) {
        this.path = path;
        this.raftMessagesFactory = raftOptions.getRaftMessagesFactory();
    }

    public abstract byte[] encode();

    public abstract boolean decode(byte[] var1);

    public synchronized boolean save() throws IOException {
        MessageFile file = new MessageFile(this.path);
        byte[] data = this.encode();
        LocalFileMetaOutter.LocalFileMeta meta = this.raftMessagesFactory.localFileMeta().userMeta(data).build();
        return file.save(meta, true);
    }

    public void load() throws IOException {
        MessageFile file = new MessageFile(this.path);
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)file.load();
        if (meta != null) {
            byte[] data = meta.userMeta();
            this.decode(data);
        }
    }

    public void destroy() {
        IgniteUtils.deleteIfExists(Path.of(this.path, new String[0]));
    }

    public String getPath() {
        return this.path;
    }
}

