/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class AffinityKey<K>
implements Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    private K key;
    @AffinityKeyMapped
    @GridToStringInclude(sensitive=true)
    private Object affKey;

    public AffinityKey() {
    }

    public AffinityKey(K key) {
        A.notNull(key, "key");
        this.key = key;
    }

    public AffinityKey(K key, Object affKey) {
        A.notNull(key, "key");
        this.key = key;
        this.affKey = affKey;
    }

    public K key() {
        return this.key;
    }

    public void key(K key) {
        this.key = key;
    }

    public <T> T affinityKey() {
        A.notNull(this.key, "key");
        return (T)(this.affKey == null ? this.key : this.affKey);
    }

    public void affinityKey(Object affKey) {
        this.affKey = affKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.affKey);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = in.readObject();
        this.affKey = in.readObject();
    }

    public int hashCode() {
        A.notNull(this.key, "key");
        return 31 * this.key.hashCode() + this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        A.notNull(this.key, "key");
        return obj != null && this.getClass() == obj.getClass() && this.key.equals(((AffinityKey)obj).key);
    }

    public String toString() {
        return S.toString(AffinityKey.class, this);
    }
}

