/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.CliConfirmArgument;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

@CliConfirmArgument
public class SetStateCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument
    @EnumDescription(names={"ACTIVE", "INACTIVE", "ACTIVE_READ_ONLY"}, descriptions={"Activate cluster. Cache updates are allowed", "Deactivate cluster", "Activate cluster. Cache updates are denied"})
    private ClusterState state;
    @Argument(optional=true, description="If true, cluster deactivation will be forced")
    private boolean force;
    private String clusterName;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.state);
        out.writeBoolean(this.force);
        U.writeString(out, this.clusterName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = U.readEnum(in, ClusterState.class);
        this.force = in.readBoolean();
        this.clusterName = U.readString(in);
    }

    public ClusterState state() {
        return this.state;
    }

    public void state(ClusterState state) {
        this.state = state;
    }

    public boolean force() {
        return this.force;
    }

    public void force(boolean force) {
        this.force = force;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void clusterName(String clusterName) {
        this.clusterName = clusterName;
    }
}

