/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.config.BehaviorChangeConfiguration;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PolarisConfiguration<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfiguration.class);
    private static final List<PolarisConfiguration<?>> allConfigurations = new ArrayList();
    private final String key;
    private final String description;
    private final T defaultValue;
    private final Optional<String> catalogConfigImpl;
    private final Optional<String> catalogConfigUnsafeImpl;
    private final Class<T> typ;
    private static final String SAFE_CATALOG_CONFIG_PREFIX = "polaris.config.";

    private static void registerConfiguration(PolarisConfiguration<?> configuration) {
        for (PolarisConfiguration<?> existingConfiguration : allConfigurations) {
            if (existingConfiguration.key.equals(configuration.key)) {
                throw new IllegalArgumentException(String.format("Config '%s' is already in use", configuration.key));
            }
            Map configs = Stream.of(configuration.catalogConfigImpl, configuration.catalogConfigUnsafeImpl, existingConfiguration.catalogConfigImpl, existingConfiguration.catalogConfigUnsafeImpl).flatMap(Optional::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            for (Map.Entry entry : configs.entrySet()) {
                if (entry.getValue() <= 1L) continue;
                throw new IllegalArgumentException(String.format("Catalog config %s is already in use", entry.getKey()));
            }
        }
        allConfigurations.add(configuration);
    }

    public static List<PolarisConfiguration<?>> getAllConfigurations() {
        return List.copyOf(allConfigurations);
    }

    protected PolarisConfiguration(String key, String description, T defaultValue, Optional<String> catalogConfig, Optional<String> catalogConfigUnsafe) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.catalogConfigImpl = catalogConfig;
        this.catalogConfigUnsafeImpl = catalogConfigUnsafe;
        this.typ = defaultValue.getClass();
    }

    public final boolean hasCatalogConfig() {
        return this.catalogConfigImpl.isPresent();
    }

    public final String catalogConfig() {
        return this.catalogConfigImpl.orElseThrow(() -> new IllegalStateException("Attempted to read a catalog config key from a configuration that doesn't have one."));
    }

    public final boolean hasCatalogConfigUnsafe() {
        return this.catalogConfigUnsafeImpl.isPresent();
    }

    public final String catalogConfigUnsafe() {
        return this.catalogConfigUnsafeImpl.orElseThrow(() -> new IllegalStateException("Attempted to read an unsafe catalog config key from a configuration that doesn't have one."));
    }

    T cast(Object value) {
        return this.typ.cast(value);
    }

    public final String key() {
        return this.key;
    }

    public final String description() {
        return this.description;
    }

    public final T defaultValue() {
        return this.defaultValue;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private String key;
        private String description;
        private T defaultValue;
        private Optional<String> catalogConfig = Optional.empty();
        private Optional<String> catalogConfigUnsafe = Optional.empty();

        public Builder<T> key(String key) {
            this.key = key;
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue instanceof List ? new ArrayList((List)defaultValue) : defaultValue;
            return this;
        }

        public Builder<T> catalogConfig(String catalogConfig) {
            if (!catalogConfig.startsWith(PolarisConfiguration.SAFE_CATALOG_CONFIG_PREFIX)) {
                throw new IllegalArgumentException("Catalog configs are expected to start with polaris.config.");
            }
            this.catalogConfig = Optional.of(catalogConfig);
            return this;
        }

        @Deprecated
        public Builder<T> catalogConfigUnsafe(String catalogConfig) {
            if (catalogConfig.startsWith(PolarisConfiguration.SAFE_CATALOG_CONFIG_PREFIX)) {
                throw new IllegalArgumentException("Unsafe catalog configs are not expected to start with polaris.config.");
            }
            this.catalogConfigUnsafe = Optional.of(catalogConfig);
            return this;
        }

        private void validateOrThrow() {
            if (this.key == null || this.description == null || this.defaultValue == null) {
                throw new IllegalArgumentException("key, description, and defaultValue are required");
            }
            if (this.key.contains(".")) {
                throw new IllegalArgumentException("key cannot contain `.`");
            }
        }

        public FeatureConfiguration<T> buildFeatureConfiguration() {
            this.validateOrThrow();
            FeatureConfiguration<T> config = new FeatureConfiguration<T>(this.key, this.description, this.defaultValue, this.catalogConfig, this.catalogConfigUnsafe);
            PolarisConfiguration.registerConfiguration(config);
            return config;
        }

        public BehaviorChangeConfiguration<T> buildBehaviorChangeConfiguration() {
            this.validateOrThrow();
            if (this.catalogConfig.isPresent() || this.catalogConfigUnsafe.isPresent()) {
                throw new IllegalArgumentException("catalog configs are not valid for behavior change configs");
            }
            BehaviorChangeConfiguration<T> config = new BehaviorChangeConfiguration<T>(this.key, this.description, this.defaultValue, this.catalogConfig, this.catalogConfigUnsafe);
            PolarisConfiguration.registerConfiguration(config);
            return config;
        }
    }
}

