/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value.ValueWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class NthValueFunction
extends ValueWindowFunction {
    private final int valueChannel;
    private final int nChannel;
    private final boolean ignoreNull;

    public NthValueFunction(List<Integer> argumentChannels, boolean ignoreNull) {
        this.valueChannel = argumentChannels.get(0);
        this.nChannel = argumentChannels.get(1);
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd) {
        if (frameStart < 0 || partition.isNull(this.nChannel, index)) {
            builder.appendNull();
            return;
        }
        int n = partition.getInt(this.nChannel, index);
        if (this.ignoreNull) {
            int pos;
            int nonNullCount = 0;
            for (pos = frameStart; pos <= frameEnd && (partition.isNull(this.valueChannel, pos) || ++nonNullCount != n); ++pos) {
            }
            if (pos <= frameEnd) {
                partition.writeTo(builder, this.valueChannel, pos);
            } else {
                builder.appendNull();
            }
            return;
        }
        int pos = frameStart + n - 1;
        if (pos <= frameEnd) {
            if (!partition.isNull(this.valueChannel, pos)) {
                partition.writeTo(builder, this.valueChannel, pos);
            } else {
                builder.appendNull();
            }
        } else {
            builder.appendNull();
        }
    }
}

